/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHandlerChain
implements MessageHandler {
    private final List<MessageHandler> handlers = new CopyOnWriteArrayList<MessageHandler>();

    public void add(MessageHandler handler) {
        this.handlers.add(handler);
    }

    public void add(int index, MessageHandler handler) {
        this.handlers.add(index, handler);
    }

    public void setHandlers(List<MessageHandler> handlers) {
        this.handlers.clear();
        this.handlers.addAll(handlers);
    }

    public List<MessageHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    @Override
    public final Message<?> handle(Message<?> message) {
        for (MessageHandler next : this.handlers) {
            message = next.handle(message);
            if (message != null) continue;
            return null;
        }
        return message;
    }
}

