/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.config;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.handler.AbstractMessageHandlerAdapter;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.handler.config.MessageHandlerCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageHandlerCreator
implements MessageHandlerCreator {
    @Override
    public final MessageHandler createHandler(Object object, Method method, Map<String, ?> attributes) {
        MessageHandler handler = this.doCreateHandler(object, method, attributes);
        if (handler instanceof AbstractMessageHandlerAdapter) {
            AbstractMessageHandlerAdapter adapter = (AbstractMessageHandlerAdapter)handler;
            adapter.setObject(object);
            adapter.setMethodName(method.getName());
            Order orderAnnotation = (Order)AnnotationUtils.getAnnotation((Method)method, Order.class);
            if (orderAnnotation != null) {
                adapter.setOrder(orderAnnotation.value());
            }
        }
        if (handler instanceof InitializingBean) {
            try {
                ((InitializingBean)handler).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new ConfigurationException("failed to initialize handler", e);
            }
        }
        return handler;
    }

    protected abstract MessageHandler doCreateHandler(Object var1, Method var2, Map<String, ?> var3);
}

