/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.message;

import java.util.Date;
import java.util.Set;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHeader;
import org.springframework.integration.util.IdGenerator;
import org.springframework.integration.util.RandomUuidGenerator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMessage<T>
implements Message<T> {
    private final Object id;
    private final MessageHeader header = new MessageHeader();
    private final T payload;
    private final transient IdGenerator defaultIdGenerator = new RandomUuidGenerator();

    public GenericMessage(Object id, T payload) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull(payload, (String)"payload must not be null");
        this.id = id;
        this.payload = payload;
    }

    public GenericMessage(T payload) {
        Assert.notNull(payload, (String)"payload must not be null");
        this.id = this.defaultIdGenerator.generateId();
        this.payload = payload;
    }

    public GenericMessage(T payload, MessageHeader headerToCopy) {
        this(payload);
        super.copyHeader(headerToCopy);
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public MessageHeader getHeader() {
        return this.header;
    }

    @Override
    public T getPayload() {
        return this.payload;
    }

    @Override
    public boolean isExpired() {
        Date expiration = this.header.getExpiration();
        return expiration != null ? expiration.getTime() < System.currentTimeMillis() : false;
    }

    public String toString() {
        return "[ID=" + this.id + "][Header=" + this.header + "][Payload='" + this.payload + "']";
    }

    private void copyHeader(MessageHeader headerToCopy) {
        Set<String> propertyNames = headerToCopy.getPropertyNames();
        for (String key : propertyNames) {
            this.header.setProperty(key, headerToCopy.getProperty(key));
        }
        Set<String> attributeNames = headerToCopy.getAttributeNames();
        for (String key : attributeNames) {
            this.header.setAttribute(key, headerToCopy.getAttribute(key));
        }
        this.header.setSequenceNumber(headerToCopy.getSequenceNumber());
        this.header.setSequenceSize(headerToCopy.getSequenceSize());
        this.header.setReturnAddress(headerToCopy.getReturnAddress());
    }
}

