/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.message;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageStore;
import org.springframework.integration.message.SimpleMessageStore;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrievalBlockingMessageStore
implements MessageStore {
    private final MessageStore targetMessageStore;
    private final ConcurrentMap<Object, List<SynchronousQueue<MessageHolder>>> listeners = new ConcurrentHashMap<Object, List<SynchronousQueue<MessageHolder>>>();
    private final Object listenerMonitor = new Object();

    public RetrievalBlockingMessageStore(MessageStore messageStore) {
        Assert.notNull((Object)messageStore, (String)"messageStore must not be null");
        Assert.isTrue((!(messageStore instanceof RetrievalBlockingMessageStore) ? 1 : 0) != 0, (String)("target MessageStore must not be an instance of '" + this.getClass().getName() + "'"));
        this.targetMessageStore = messageStore;
    }

    public RetrievalBlockingMessageStore(int capacity) {
        this.targetMessageStore = new SimpleMessageStore(capacity);
    }

    @Override
    public int size() {
        return this.targetMessageStore.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message<?> put(Object key, Message<?> message) {
        Message<?> previousMessage = this.targetMessageStore.put(key, message);
        boolean sentReply = false;
        List listenerList = null;
        Object object = this.listenerMonitor;
        synchronized (object) {
            listenerList = (List)this.listeners.remove(key);
        }
        if (listenerList != null) {
            int i = 0;
            while (i < listenerList.size()) {
                Queue queue = (Queue)listenerList.get(i);
                if (!sentReply) {
                    sentReply = queue.offer(new MessageHolder(message));
                } else {
                    queue.offer(new MessageHolder(null));
                }
                ++i;
            }
        }
        return previousMessage;
    }

    @Override
    public Message<?> get(Object key) {
        return this.get(key, -1L);
    }

    public Message<?> get(Object key, long timeout) {
        Message<?> message = this.targetMessageStore.get(key);
        return message != null ? message : this.waitForMessage(key, timeout, false);
    }

    @Override
    public Message<?> remove(Object key) {
        return this.remove(key, -1L);
    }

    public Message<?> remove(Object key, long timeout) {
        Message<?> message = this.targetMessageStore.remove(key);
        return message != null ? message : this.waitForMessage(key, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message<?> waitForMessage(Object key, long timeout, boolean shouldRemove) {
        Message<?> message;
        block29: {
            SynchronousQueue queue;
            block28: {
                Object object;
                Message<?> message2;
                message = null;
                queue = new SynchronousQueue();
                Object object2 = this.listenerMonitor;
                synchronized (object2) {
                    LinkedList listenerList = (LinkedList)this.listeners.get(key);
                    if (listenerList == null) {
                        listenerList = new LinkedList();
                        this.listeners.put(key, listenerList);
                    }
                    listenerList.add(queue);
                }
                try {
                    MessageHolder holder;
                    MessageHolder messageHolder = holder = timeout < 0L ? (MessageHolder)queue.take() : (MessageHolder)queue.poll(timeout, TimeUnit.MILLISECONDS);
                    if (holder == null || (message = holder.getMessage()) == null || !shouldRemove) break block28;
                    message2 = this.targetMessageStore.remove(key);
                    object = this.listenerMonitor;
                }
                catch (InterruptedException interruptedException) {
                    Object object3;
                    try {
                        Thread.currentThread().interrupt();
                        object3 = this.listenerMonitor;
                    }
                    catch (Throwable throwable) {
                        Object object4 = this.listenerMonitor;
                        synchronized (object4) {
                            List listenerList = (List)this.listeners.get(key);
                            if (listenerList != null) {
                                listenerList.remove(queue);
                                if (listenerList.size() == 0) {
                                    this.listeners.remove(key);
                                }
                            }
                        }
                        throw throwable;
                    }
                    synchronized (object3) {
                        List listenerList = (List)this.listeners.get(key);
                        if (listenerList != null) {
                            listenerList.remove(queue);
                            if (listenerList.size() == 0) {
                                this.listeners.remove(key);
                            }
                        }
                        break block29;
                    }
                }
                synchronized (object) {
                    List listenerList = (List)this.listeners.get(key);
                    if (listenerList != null) {
                        listenerList.remove(queue);
                        if (listenerList.size() == 0) {
                            this.listeners.remove(key);
                        }
                    }
                }
                return message2;
            }
            Object object = this.listenerMonitor;
            synchronized (object) {
                List listenerList = (List)this.listeners.get(key);
                if (listenerList != null) {
                    listenerList.remove(queue);
                    if (listenerList.size() == 0) {
                        this.listeners.remove(key);
                    }
                }
            }
        }
        return message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageHolder {
        private final Message<?> message;

        MessageHolder(Message<?> message) {
            this.message = message;
        }

        Message<?> getMessage() {
            return this.message;
        }
    }
}

