/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.message;

import java.util.Map;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageStore;
import org.springframework.integration.util.BoundedHashMap;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMessageStore
implements MessageStore {
    private final Map<Object, Message<?>> map;

    public SimpleMessageStore(int capacity) {
        this.map = new BoundedHashMap(capacity);
    }

    @Override
    public Message<?> put(Object key, Message<?> message) {
        Assert.notNull((Object)key, (String)"'key' must not be null");
        Assert.notNull(message, (String)"'message' must not be null");
        return this.map.put(key, message);
    }

    @Override
    public Message<?> get(Object key) {
        return key != null ? this.map.get(key) : null;
    }

    @Override
    public Message<?> remove(Object key) {
        return key != null ? this.map.remove(key) : null;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

