/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.integration.router.AggregationBarrier;
import org.springframework.integration.router.Aggregator;
import org.springframework.integration.router.CompletionStrategy;
import org.springframework.integration.router.SequenceSizeCompletionStrategy;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingMessageHandler
implements MessageHandler,
InitializingBean {
    public static final long DEFAULT_SEND_TIMEOUT = 1000L;
    public static final long DEFAULT_TIMEOUT = 60000L;
    public static final long DEFAULT_REAPER_INTERVAL = 1000L;
    public static final int DEFAULT_TRACKED_CORRRELATION_ID_CAPACITY = 1000;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Aggregator aggregator;
    private volatile MessageChannel defaultReplyChannel;
    private volatile MessageChannel discardChannel;
    private volatile long sendTimeout = 1000L;
    private volatile CompletionStrategy completionStrategy = new SequenceSizeCompletionStrategy();
    private final ConcurrentMap<Object, AggregationBarrier> barriers = new ConcurrentHashMap<Object, AggregationBarrier>();
    private volatile long timeout = 60000L;
    private volatile boolean sendPartialResultOnTimeout = false;
    private volatile long reaperInterval = 1000L;
    private volatile int trackedCorrelationIdCapacity = 1000;
    private volatile BlockingQueue<Object> trackedCorrelationIds;
    private final ScheduledExecutorService executor;
    private volatile boolean initialized;

    public AggregatingMessageHandler(Aggregator aggregator, ScheduledExecutorService executor) {
        Assert.notNull((Object)aggregator, (String)"'aggregator' must not be null");
        this.aggregator = aggregator;
        this.executor = executor != null ? executor : Executors.newSingleThreadScheduledExecutor();
    }

    public AggregatingMessageHandler(Aggregator aggregator) {
        this(aggregator, null);
    }

    public void setDefaultReplyChannel(MessageChannel defaultReplyChannel) {
        this.defaultReplyChannel = defaultReplyChannel;
    }

    public void setDiscardChannel(MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setSendPartialResultOnTimeout(boolean sendPartialResultOnTimeout) {
        this.sendPartialResultOnTimeout = sendPartialResultOnTimeout;
    }

    public void setReaperInterval(long reaperInterval) {
        Assert.isTrue((reaperInterval > 0L ? 1 : 0) != 0, (String)"'reaperInterval' must be a positive value");
        this.reaperInterval = reaperInterval;
    }

    public void setTrackedCorrelationIdCapacity(int trackedCorrelationIdCapacity) {
        Assert.isTrue((trackedCorrelationIdCapacity > 0 ? 1 : 0) != 0, (String)"'trackedCorrelationIdCapacity' must be a positive value");
        this.trackedCorrelationIdCapacity = trackedCorrelationIdCapacity;
    }

    public void afterPropertiesSet() {
        this.trackedCorrelationIds = new ArrayBlockingQueue<Object>(this.trackedCorrelationIdCapacity);
        this.executor.scheduleWithFixedDelay(new ReaperTask(), this.reaperInterval, this.reaperInterval, TimeUnit.MILLISECONDS);
        this.initialized = true;
    }

    public void setCompletionStrategy(CompletionStrategy completionStrategy) {
        Assert.notNull((Object)completionStrategy, (String)"'completionStrategy' must not be null");
        this.completionStrategy = completionStrategy;
    }

    public void setTimeout(long timeout) {
        Assert.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"'timeout' must not be negative");
        this.timeout = timeout;
    }

    @Override
    public Message<?> handle(Message<?> message) {
        List<Message<?>> releasedMessages;
        Object correlationId;
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
        if ((correlationId = message.getHeader().getCorrelationId()) == null) {
            throw new MessageHandlingException(message, String.valueOf(this.getClass().getSimpleName()) + " requires the 'correlationId' property");
        }
        if (this.trackedCorrelationIds.contains(correlationId)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Aggregation for correlationId '" + correlationId + "' has already completed or timed out."));
            }
            this.sendToDiscardChannelIfAvailable(message);
            return null;
        }
        AggregationBarrier barrier = this.barriers.putIfAbsent(correlationId, new AggregationBarrier(this.completionStrategy));
        if (barrier == null) {
            barrier = (AggregationBarrier)this.barriers.get(correlationId);
        }
        if (CollectionUtils.isEmpty(releasedMessages = barrier.addAndRelease(message))) {
            return null;
        }
        this.removeBarrier(correlationId);
        this.aggregationCompleted(correlationId, releasedMessages);
        return null;
    }

    private void sendToDiscardChannelIfAvailable(Message<?> message) {
        if (this.discardChannel != null && !this.discardChannel.send(message, this.sendTimeout) && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("unable to send to 'discardChannel', message: " + message));
        }
    }

    private void aggregationCompleted(Object correlationId, List<Message<?>> messages) {
        if (CollectionUtils.isEmpty(messages)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"no messages to aggregate");
            }
            return;
        }
        Message<?> result = this.aggregator.aggregate(messages);
        MessageChannel replyChannel = this.resolveReplyChannelFromMessage(result);
        if (replyChannel == null && (replyChannel = this.resolveReplyChannelFromMessage(messages.get(0))) == null) {
            replyChannel = this.defaultReplyChannel;
        }
        if (replyChannel != null) {
            replyChannel.send(result, this.sendTimeout);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("unable to determine reply channel for aggregation result: " + result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBarrier(Object correlationId) {
        if (this.barriers.remove(correlationId) != null) {
            BlockingQueue<Object> blockingQueue = this.trackedCorrelationIds;
            synchronized (blockingQueue) {
                boolean added = this.trackedCorrelationIds.offer(correlationId);
                if (!added) {
                    this.trackedCorrelationIds.poll();
                    this.trackedCorrelationIds.offer(correlationId);
                }
            }
        }
    }

    private MessageChannel resolveReplyChannelFromMessage(Message<?> message) {
        Object returnAddress = message.getHeader().getReturnAddress();
        if (returnAddress != null) {
            if (returnAddress instanceof MessageChannel) {
                return (MessageChannel)returnAddress;
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Aggregator can only reply to a 'returnAddress' of type MessageChannel.");
            }
        }
        return null;
    }

    private class ReaperTask
    implements Runnable {
        private ReaperTask() {
        }

        public void run() {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry entry : AggregatingMessageHandler.this.barriers.entrySet()) {
                if (currentTime - ((AggregationBarrier)entry.getValue()).getTimestamp() < AggregatingMessageHandler.this.timeout) continue;
                Object correlationId = entry.getKey();
                List<Message<?>> messages = ((AggregationBarrier)entry.getValue()).getMessages();
                AggregatingMessageHandler.this.removeBarrier(correlationId);
                if (AggregatingMessageHandler.this.sendPartialResultOnTimeout) {
                    AggregatingMessageHandler.this.aggregationCompleted(correlationId, messages);
                    continue;
                }
                for (Message<?> message : messages) {
                    AggregatingMessageHandler.this.sendToDiscardChannelIfAvailable(message);
                }
            }
        }
    }
}

