/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.message.Message;
import org.springframework.integration.router.CompletionStrategy;
import org.springframework.integration.router.MessageBarrier;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationBarrier
implements MessageBarrier {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<Message<?>> messages = new CopyOnWriteArrayList();
    private final CompletionStrategy completionStrategy;
    private volatile boolean complete = false;
    private final ReentrantLock lock = new ReentrantLock();
    private final long timestamp = System.currentTimeMillis();

    public AggregationBarrier(CompletionStrategy completionStrategy) {
        Assert.notNull((Object)completionStrategy, (String)"'completionStrategy' must not be null");
        this.completionStrategy = completionStrategy;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<Message<?>> addAndRelease(Message<?> message) {
        try {
            this.lock.lock();
            if (this.complete) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Message received after aggregation has already completed: " + message));
                }
                return null;
            }
            this.messages.add(message);
            boolean complete = this.completionStrategy.isComplete(this.messages);
            List<Message<?>> list = complete ? this.messages : null;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Message<?>> getMessages() {
        return this.messages;
    }
}

