/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.handler.HandlerMethodInvoker;
import org.springframework.integration.message.Message;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageListMethodAdapter {
    private final HandlerMethodInvoker<Object> invoker;
    protected volatile Method method;

    public MessageListMethodAdapter(Object object, String methodName) {
        Assert.notNull((Object)object, (String)"'object' must not be null");
        Assert.notNull((Object)methodName, (String)"'methodName' must not be null");
        this.method = ReflectionUtils.findMethod(object.getClass(), (String)methodName, (Class[])new Class[]{List.class});
        if (this.method == null) {
            throw new ConfigurationException("Method '" + methodName + "(List<?> args)' not found on '" + object.getClass().getName() + "'.");
        }
        this.invoker = new HandlerMethodInvoker<Object>(object, this.method.getName());
    }

    public MessageListMethodAdapter(Object object, Method method) {
        Assert.notNull((Object)object, (String)"'object' must not be null");
        Assert.notNull((Object)method, (String)"'method' must not be null");
        if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(List.class)) {
            throw new ConfigurationException("Method must accept exactly one parameter, and it must be a List.");
        }
        this.method = method;
        this.invoker = new HandlerMethodInvoker<Object>(object, this.method.getName());
    }

    private static boolean isActualTypeParameterizedMessage(Method method) {
        return MessageListMethodAdapter.getCollectionActualType(method) instanceof ParameterizedType && Message.class.isAssignableFrom((Class)((ParameterizedType)MessageListMethodAdapter.getCollectionActualType(method)).getRawType());
    }

    protected final Object executeMethod(List<Message<?>> messages) {
        if (MessageListMethodAdapter.isMethodParameterParameterized(this.method) && MessageListMethodAdapter.isHavingActualTypeArguments(this.method) && (MessageListMethodAdapter.isActualTypeRawMessage(this.method) || MessageListMethodAdapter.isActualTypeParameterizedMessage(this.method))) {
            return this.invoker.invokeMethod(messages);
        }
        return this.invoker.invokeMethod(this.extractPayloadsFromMessages(messages));
    }

    private List<?> extractPayloadsFromMessages(List<Message<?>> messages) {
        ArrayList payloadList = new ArrayList();
        for (Message<?> message : messages) {
            payloadList.add(message.getPayload());
        }
        return payloadList;
    }

    private static boolean isActualTypeRawMessage(Method method) {
        return MessageListMethodAdapter.getCollectionActualType(method).equals(Message.class);
    }

    private static Type getCollectionActualType(Method method) {
        return ((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0];
    }

    private static boolean isHavingActualTypeArguments(Method method) {
        return ((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments().length == 1;
    }

    private static boolean isMethodParameterParameterized(Method method) {
        return method.getGenericParameterTypes().length == 1 && method.getGenericParameterTypes()[0] instanceof ParameterizedType;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }
}

