/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.ArrayList;
import java.util.List;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.Message;
import org.springframework.integration.router.AbstractRoutingMessageHandler;
import org.springframework.integration.router.ChannelNameResolver;
import org.springframework.integration.router.ChannelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleChannelRouter
extends AbstractRoutingMessageHandler {
    private ChannelResolver channelResolver;
    private ChannelNameResolver channelNameResolver;

    public void setChannelResolver(ChannelResolver channelResolver) {
        this.channelResolver = channelResolver;
    }

    public void setChannelNameResolver(ChannelNameResolver channelNameResolver) {
        this.channelNameResolver = channelNameResolver;
    }

    @Override
    public void validate() {
        if (!(this.channelResolver != null ^ this.channelNameResolver != null)) {
            throw new ConfigurationException("exactly one of 'channelResolver' or 'channelNameResolver' must be provided");
        }
        if (this.channelNameResolver != null && this.getChannelRegistry() == null) {
            throw new ConfigurationException("'channelRegistry' is required when resolving by channel name");
        }
    }

    @Override
    public List<MessageChannel> resolveChannels(Message<?> message) {
        ArrayList<MessageChannel> channels = new ArrayList<MessageChannel>();
        MessageChannel channel = this.resolveChannel(message);
        if (channel != null) {
            channels.add(channel);
        }
        return channels;
    }

    private MessageChannel resolveChannel(Message<?> message) {
        if (this.channelResolver != null) {
            return this.channelResolver.resolve(message);
        }
        if (this.channelNameResolver == null || this.getChannelRegistry() == null) {
            throw new ConfigurationException("router configuration requires either a 'channelResolver' or both 'channelNameResolver' and 'channelRegistry'");
        }
        String channelName = this.channelNameResolver.resolve(message);
        return this.getChannelRegistry().lookupChannel(channelName);
    }
}

