/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scheduling;

import java.util.concurrent.TimeUnit;
import org.springframework.integration.scheduling.Schedule;
import org.springframework.util.Assert;

public class PollingSchedule
implements Schedule {
    public static final long DEFAULT_INITIAL_DELAY = 0L;
    public static final boolean DEFAULT_FIXED_RATE = false;
    private volatile long period;
    private volatile long initialDelay = 0L;
    private volatile TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private volatile boolean fixedRate = false;

    public PollingSchedule(long period) {
        this.period = period;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        Assert.isTrue((initialDelay >= 0L ? 1 : 0) != 0, (String)"'initialDelay' must not be negative");
        this.initialDelay = initialDelay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        Assert.notNull((Object)((Object)timeUnit), (String)"'timeUnit' must not be null");
        this.timeUnit = timeUnit;
    }

    public boolean getFixedRate() {
        return this.fixedRate;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public int hashCode() {
        return this.toString().hashCode() * 23;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return other instanceof PollingSchedule && this.toString().equals(((PollingSchedule)other).toString());
    }

    public String toString() {
        return "initialDelay=" + this.initialDelay + ", period=" + this.period + ", timeUnit=" + (Object)((Object)this.timeUnit) + ", fixedRate=" + this.fixedRate;
    }
}

