/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scheduling;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.scheduling.AbstractMessagingTaskScheduler;
import org.springframework.integration.scheduling.MessagingTask;
import org.springframework.integration.scheduling.PollingSchedule;
import org.springframework.integration.scheduling.Schedule;
import org.springframework.integration.util.ErrorHandler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMessagingTaskScheduler
extends AbstractMessagingTaskScheduler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ScheduledExecutorService executor;
    private volatile ErrorHandler errorHandler;
    private final Set<Runnable> pendingTasks = new CopyOnWriteArraySet<Runnable>();
    private volatile boolean running;
    private final Object lifecycleMonitor = new Object();

    public SimpleMessagingTaskScheduler(ScheduledExecutorService executor) {
        Assert.notNull((Object)executor, (String)"'executor' must not be null");
        this.executor = executor;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                return;
            }
            this.running = true;
            for (Runnable task : this.pendingTasks) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("scheduling task: " + task));
                }
                this.schedule(task);
            }
            this.pendingTasks.clear();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"task scheduler started successfully");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                this.executor.shutdownNow();
                this.running = false;
            }
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task) {
        if (!this.running) {
            this.pendingTasks.add(task);
            return null;
        }
        Schedule schedule = task instanceof MessagingTask ? ((MessagingTask)task).getSchedule() : null;
        MessagingTaskRunner runner = new MessagingTaskRunner(task);
        if (schedule == null) {
            return this.executor.schedule(runner, 0L, TimeUnit.MILLISECONDS);
        }
        if (schedule instanceof PollingSchedule) {
            PollingSchedule ps = (PollingSchedule)schedule;
            if (ps.getPeriod() <= 0L) {
                runner.setShouldRepeat(true);
                return this.executor.schedule(runner, ps.getInitialDelay(), ps.getTimeUnit());
            }
            if (ps.getFixedRate()) {
                return this.executor.scheduleAtFixedRate(runner, ps.getInitialDelay(), ps.getPeriod(), ps.getTimeUnit());
            }
            return this.executor.scheduleWithFixedDelay(runner, ps.getInitialDelay(), ps.getPeriod(), ps.getTimeUnit());
        }
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not support schedule type '" + schedule.getClass().getName() + "'");
    }

    private class MessagingTaskRunner
    implements Runnable {
        private final Runnable task;
        private volatile boolean shouldRepeat;

        public MessagingTaskRunner(Runnable task) {
            this.task = task;
        }

        public void setShouldRepeat(boolean shouldRepeat) {
            this.shouldRepeat = shouldRepeat;
        }

        public void run() {
            block4: {
                try {
                    this.task.run();
                }
                catch (Throwable t) {
                    if (SimpleMessagingTaskScheduler.this.errorHandler != null) {
                        SimpleMessagingTaskScheduler.this.errorHandler.handle(t);
                    }
                    if (!SimpleMessagingTaskScheduler.this.logger.isWarnEnabled()) break block4;
                    SimpleMessagingTaskScheduler.this.logger.warn((Object)"error occurred in task but no 'errorHandler' is available", t);
                }
            }
            if (this.shouldRepeat) {
                MessagingTaskRunner runner = new MessagingTaskRunner(this.task);
                runner.setShouldRepeat(true);
                SimpleMessagingTaskScheduler.this.executor.execute(runner);
            }
        }
    }
}

