/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.bus;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.channel.RendezvousChannel;
import org.springframework.integration.channel.interceptor.ChannelInterceptorAdapter;
import org.springframework.integration.message.Message;

public class DefaultErrorChannel
extends RendezvousChannel {
    private final Log logger = LogFactory.getLog(this.getClass());

    public DefaultErrorChannel() {
        this.addInterceptor(new ErrorLoggingInterceptor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ErrorLoggingInterceptor
    extends ChannelInterceptorAdapter {
        private ErrorLoggingInterceptor() {
        }

        @Override
        public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
            if (!sent && DefaultErrorChannel.this.logger.isWarnEnabled()) {
                DefaultErrorChannel.this.logger.warn((Object)("Error channel rejected Message. Are any handlers subscribed? " + message));
            }
        }

        @Override
        public boolean preSend(Message<?> message, MessageChannel channel) {
            if (DefaultErrorChannel.this.logger.isDebugEnabled()) {
                String errorMessage = "Error Received. Message: " + message.toString();
                Object payload = message.getPayload();
                if (payload instanceof Throwable) {
                    DefaultErrorChannel.this.logger.debug((Object)errorMessage, (Throwable)payload);
                } else {
                    DefaultErrorChannel.this.logger.debug((Object)errorMessage);
                }
            }
            return true;
        }
    }
}

