/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.Message;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelPublisher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile MessageChannel channel;
    private volatile long timeout = 0L;

    public ChannelPublisher() {
    }

    public ChannelPublisher(MessageChannel channel) {
        this.setChannel(channel);
    }

    public void setChannel(MessageChannel channel) {
        Assert.notNull((Object)channel, (String)"channel must not be null");
        this.channel = channel;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected MessageChannel getChannel() {
        return this.channel;
    }

    public boolean publish(Message<?> message) {
        if (this.channel == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"unable to send message, no channel available");
            }
            return false;
        }
        if (message == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"null messages are not supported");
            }
            return false;
        }
        return this.timeout < 0L ? this.channel.send(message) : this.channel.send(message, this.timeout);
    }
}

