/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.util.Assert;

public class DefaultChannelRegistry
implements ChannelRegistry {
    private final Map<String, MessageChannel> channels = new ConcurrentHashMap<String, MessageChannel>();

    public MessageChannel lookupChannel(String channelName) {
        return this.channels.get(channelName);
    }

    public void registerChannel(String name, MessageChannel channel) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        Assert.notNull((Object)channel, (String)"'channel' must not be null");
        this.channels.put(name, channel);
    }

    public MessageChannel unregisterChannel(String name) {
        return name != null ? this.channels.remove(name) : null;
    }
}

