/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.MessageEndpointAnnotationPostProcessor;
import org.springframework.integration.config.PublisherAnnotationPostProcessor;
import org.springframework.integration.config.SubscriberAnnotationPostProcessor;
import org.w3c.dom.Element;

public class AnnotationDrivenParser
implements BeanDefinitionParser {
    private static final String PUBLISHER_ANNOTATION_POST_PROCESSOR_BEAN_NAME = "internal.PublisherAnnotationPostProcessor";
    private static final String SUBSCRIBER_ANNOTATION_POST_PROCESSOR_BEAN_NAME = "internal.SubscriberAnnotationPostProcessor";
    private static final String MESSAGE_ENDPOINT_ANNOTATION_POST_PROCESSOR_BEAN_NAME = "internal.MessageEndpointAnnotationPostProcessor";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.createPublisherPostProcessor(parserContext);
        this.createSubscriberPostProcessor(parserContext);
        this.createMessageEndpointPostProcessor(parserContext);
        return null;
    }

    private void createPublisherPostProcessor(ParserContext parserContext) {
        RootBeanDefinition bd = new RootBeanDefinition(PublisherAnnotationPostProcessor.class);
        bd.getPropertyValues().addPropertyValue("channelRegistry", (Object)new RuntimeBeanReference("internal.MessageBus"));
        BeanComponentDefinition bcd = new BeanComponentDefinition((BeanDefinition)bd, PUBLISHER_ANNOTATION_POST_PROCESSOR_BEAN_NAME);
        parserContext.registerBeanComponent(bcd);
    }

    private void createSubscriberPostProcessor(ParserContext parserContext) {
        RootBeanDefinition bd = new RootBeanDefinition(SubscriberAnnotationPostProcessor.class);
        bd.getPropertyValues().addPropertyValue("messageBus", (Object)new RuntimeBeanReference("internal.MessageBus"));
        BeanComponentDefinition bcd = new BeanComponentDefinition((BeanDefinition)bd, SUBSCRIBER_ANNOTATION_POST_PROCESSOR_BEAN_NAME);
        parserContext.registerBeanComponent(bcd);
    }

    private void createMessageEndpointPostProcessor(ParserContext parserContext) {
        RootBeanDefinition bd = new RootBeanDefinition(MessageEndpointAnnotationPostProcessor.class);
        bd.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference("internal.MessageBus"));
        BeanComponentDefinition bcd = new BeanComponentDefinition((BeanDefinition)bd, MESSAGE_ENDPOINT_ANNOTATION_POST_PROCESSOR_BEAN_NAME);
        parserContext.registerBeanComponent(bcd);
    }
}

