/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.integration.annotation.Publisher;
import org.springframework.integration.aop.PublisherAnnotationAdvisor;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherAnnotationPostProcessor
implements BeanPostProcessor,
BeanClassLoaderAware {
    private Class<? extends Annotation> publisherAnnotationType = Publisher.class;
    private String channelNameAttribute = "channel";
    private ChannelRegistry channelRegistry;
    private Advisor advisor;
    private ClassLoader beanClassLoader;

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        Assert.notNull((Object)beanClassLoader, (String)"'beanClassLoader' must not be null");
        this.beanClassLoader = beanClassLoader;
    }

    public void setPublisherAnnotationType(Class<? extends Annotation> publisherAnnotationType) {
        Assert.notNull(publisherAnnotationType, (String)"'publisherAnnotationType' must not be null");
        this.publisherAnnotationType = publisherAnnotationType;
    }

    public void setChannelNameAttribute(String channelNameAttribute) {
        Assert.notNull((Object)channelNameAttribute, (String)"'channelNameAttribute' must not be null");
        this.channelNameAttribute = channelNameAttribute;
    }

    public void setChannelRegistry(ChannelRegistry channelRegistry) {
        Assert.notNull((Object)channelRegistry, (String)"'channelRegistry' must not be null");
        this.channelRegistry = channelRegistry;
    }

    private void createAdvisor() {
        if (this.channelRegistry == null) {
            throw new IllegalStateException("'channelRegistry' is required");
        }
        this.advisor = new PublisherAnnotationAdvisor(this.publisherAnnotationType, this.channelNameAttribute, this.channelRegistry);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (targetClass == null) {
            return bean;
        }
        if (this.advisor == null) {
            this.createAdvisor();
        }
        if (AopUtils.canApply((Advisor)this.advisor, (Class)targetClass)) {
            if (bean instanceof Advised) {
                ((Advised)bean).addAdvisor(this.advisor);
                return bean;
            }
            ProxyFactory pf = new ProxyFactory(bean);
            pf.addAdvisor(this.advisor);
            return pf.getProxy(this.beanClassLoader);
        }
        return bean;
    }
}

