/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.endpoint.PollingSourceEndpoint;
import org.springframework.integration.scheduling.PollingSchedule;
import org.springframework.integration.scheduling.Schedule;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceEndpointParser
extends AbstractSimpleBeanDefinitionParser {
    protected final Class<?> getBeanClass(Element element) {
        return PollingSourceEndpoint.class;
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected boolean isEligibleAttribute(String name) {
        return !"source".equals(name) && !"channel".equals(name) && super.isEligibleAttribute(name);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String source = element.getAttribute("source");
        if (!StringUtils.hasText((String)source)) {
            throw new ConfigurationException("'source' is required");
        }
        String output = element.getAttribute("channel");
        if (!StringUtils.hasText((String)output)) {
            throw new ConfigurationException("'channel' is required");
        }
        builder.addConstructorArgReference(source);
        builder.addConstructorArgReference(output);
        Element scheduleElement = this.getScheduleElement(element);
        if (scheduleElement == null) {
            throw new ConfigurationException("The <schedule/> sub-element is required for a <source-endpoint/>.");
        }
        builder.addConstructorArgValue((Object)this.parseSchedule(scheduleElement));
    }

    protected Schedule parseSchedule(Element element) {
        String period = element.getAttribute("period");
        if (!StringUtils.hasText((String)period)) {
            throw new ConfigurationException("The 'period' attribute is required for the 'schedule' element.");
        }
        PollingSchedule schedule = new PollingSchedule(Long.valueOf(period));
        return schedule;
    }

    private Element getScheduleElement(Element element) {
        return DomUtils.getChildElementByTagName((Element)element, (String)"schedule");
    }
}

