/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.endpoint;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Lifecycle;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.integration.channel.ChannelRegistryAware;
import org.springframework.integration.endpoint.ConcurrencyPolicy;
import org.springframework.integration.endpoint.ConcurrentTarget;
import org.springframework.integration.endpoint.MessageEndpoint;
import org.springframework.integration.handler.MessageHandlerNotRunningException;
import org.springframework.integration.handler.MessageHandlerRejectedExecutionException;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.integration.message.Target;
import org.springframework.integration.message.selector.MessageSelector;
import org.springframework.integration.scheduling.Subscription;
import org.springframework.integration.util.ErrorHandler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetEndpoint
implements Target,
MessageEndpoint,
ChannelRegistryAware,
InitializingBean,
Lifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile String name;
    private volatile Target target;
    private volatile Subscription subscription;
    private volatile ConcurrencyPolicy concurrencyPolicy;
    private volatile ErrorHandler errorHandler;
    private final List<MessageSelector> selectors = new CopyOnWriteArrayList<MessageSelector>();
    private volatile ChannelRegistry channelRegistry;
    private volatile boolean initialized;
    private volatile boolean running;

    public TargetEndpoint() {
    }

    public TargetEndpoint(Target target) {
        Assert.notNull((Object)target, (String)"target must not be null");
        this.target = target;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeanName(String beanName) {
        this.setName(beanName);
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        Assert.notNull((Object)target, (String)"target must not be null");
        this.target = target;
    }

    public void setMessageSelectors(List<MessageSelector> selectors) {
        this.selectors.clear();
        this.selectors.addAll(selectors);
    }

    public void addMessageSelector(MessageSelector messageSelector) {
        Assert.notNull((Object)messageSelector, (String)"'messageSelector' must not be null");
        this.selectors.add(messageSelector);
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public ConcurrencyPolicy getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    public void setConcurrencyPolicy(ConcurrencyPolicy concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean hasErrorHandler() {
        return this.errorHandler != null;
    }

    @Override
    public void setChannelRegistry(ChannelRegistry channelRegistry) {
        this.channelRegistry = channelRegistry;
    }

    protected ChannelRegistry getChannelRegistry() {
        return this.channelRegistry;
    }

    public void afterPropertiesSet() {
        if (this.target instanceof ChannelRegistryAware && this.channelRegistry != null) {
            ((ChannelRegistryAware)((Object)this.target)).setChannelRegistry(this.channelRegistry);
        }
        if (this.concurrencyPolicy != null && !(this.target instanceof ConcurrentTarget)) {
            int capacity = this.concurrencyPolicy.getQueueCapacity();
            SynchronousQueue<Runnable> queue = capacity < 1 ? new SynchronousQueue() : new ArrayBlockingQueue(capacity);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(this.concurrencyPolicy.getCoreSize(), this.concurrencyPolicy.getMaxSize(), this.concurrencyPolicy.getKeepAliveSeconds(), TimeUnit.SECONDS, queue);
            this.target = new ConcurrentTarget(this.target, executor);
        }
        if (this.target instanceof ConcurrentTarget && this.errorHandler != null) {
            ((ConcurrentTarget)this.target).setErrorHandler(this.errorHandler);
        }
        this.initialized = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
        this.running = true;
    }

    public void stop() {
        block4: {
            if (!this.isRunning()) {
                return;
            }
            if (this.target instanceof DisposableBean) {
                try {
                    ((DisposableBean)this.target).destroy();
                }
                catch (Exception e) {
                    if (!this.logger.isWarnEnabled()) break block4;
                    this.logger.warn((Object)"exception occurred when destroying target", (Throwable)e);
                }
            }
        }
        this.running = false;
    }

    @Override
    public final boolean send(Message<?> message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("endpoint '" + this + "' handling message: " + message));
        }
        if (!this.isRunning()) {
            throw new MessageHandlerNotRunningException(message);
        }
        for (MessageSelector selector : this.selectors) {
            if (selector.accept(message)) continue;
            return false;
        }
        try {
            return this.target.send(message);
        }
        catch (MessageHandlerRejectedExecutionException e) {
            throw e;
        }
        catch (Throwable t) {
            if (this.errorHandler == null) {
                if (t instanceof MessageHandlingException) {
                    throw (MessageHandlingException)t;
                }
                throw new MessageHandlingException(message, "error occurred in endpoint, and no 'errorHandler' available", t);
            }
            this.errorHandler.handle(t);
            return false;
        }
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }
}

