/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.bus.MessageBus;
import org.springframework.integration.gateway.MessagingGateway;
import org.springframework.integration.message.Message;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayProxyFactoryBean
extends MessagingGateway
implements FactoryBean,
MethodInterceptor,
InitializingBean,
BeanClassLoaderAware,
BeanFactoryAware {
    private Class<?> serviceInterface;
    private TypeConverter typeConverter = new SimpleTypeConverter();
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object serviceProxy;

    public void setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        Assert.notNull((Object)typeConverter, (String)"typeConverter must not be null");
        this.typeConverter = typeConverter;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.getRequestReplyTemplate().setMessageBus((MessageBus)beanFactory.getBean("internal.MessageBus"));
    }

    public void afterPropertiesSet() {
        this.serviceProxy = new ProxyFactory(this.serviceInterface, (Interceptor)this).getProxy(this.beanClassLoader);
    }

    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> returnType = invocation.getMethod().getReturnType();
        boolean shouldReturnMessage = Message.class.isAssignableFrom(returnType);
        int paramCount = invocation.getMethod().getParameterTypes().length;
        Object response = null;
        if (paramCount == 0) {
            if (shouldReturnMessage) {
                return this.receive();
            }
            response = this.receive();
        } else {
            Object[] payload;
            Object object = payload = paramCount == 1 ? invocation.getArguments()[0] : invocation.getArguments();
            if (returnType.equals(Void.TYPE)) {
                this.send(payload);
                return null;
            }
            response = shouldReturnMessage ? this.sendAndReceiveMessage(payload) : this.sendAndReceive(payload);
        }
        return response != null ? this.typeConverter.convertIfNecessary(response, returnType) : null;
    }
}

