/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.message.selector;

import java.util.ArrayList;
import java.util.List;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.selector.MessageSelector;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadTypeSelector
implements MessageSelector {
    private List<Class<?>> acceptedTypes = new ArrayList();

    public PayloadTypeSelector(Class<?> ... types) {
        Assert.notEmpty((Object[])types, (String)"at least one type is required");
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            this.acceptedTypes.add(type);
            ++n2;
        }
    }

    @Override
    public boolean accept(Message<?> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        Object payload = message.getPayload();
        Assert.notNull(payload, (String)"'payload' must not be null");
        for (Class<?> type : this.acceptedTypes) {
            if (!type.isAssignableFrom(payload.getClass())) continue;
            return true;
        }
        return false;
    }
}

