/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.integration.channel.ChannelRegistryAware;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHandlingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRoutingMessageHandler
implements MessageHandler,
ChannelRegistryAware,
InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ChannelRegistry channelRegistry;
    private boolean resolutionRequired = false;
    private long timeout = -1L;

    public void setResolutionRequired(boolean resolutionRequired) {
        this.resolutionRequired = resolutionRequired;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setChannelRegistry(ChannelRegistry channelRegistry) {
        this.channelRegistry = channelRegistry;
    }

    protected ChannelRegistry getChannelRegistry() {
        return this.channelRegistry;
    }

    public final void afterPropertiesSet() {
        this.validate();
    }

    @Override
    public final Message<?> handle(Message<?> message) {
        List<MessageChannel> channels = this.resolveChannels(message);
        if (channels == null || channels.size() == 0) {
            String description = "failed to resolve any channel for message";
            if (this.resolutionRequired) {
                throw new MessageHandlingException(message, description);
            }
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)description);
            }
            return null;
        }
        for (MessageChannel channel : channels) {
            this.sendMesage(message, channel);
        }
        return null;
    }

    private void sendMesage(Message<?> message, MessageChannel channel) {
        boolean sent = false;
        sent = this.timeout < 0L ? channel.send(message) : channel.send(message, this.timeout);
        if (!sent) {
            throw new MessageHandlingException(message, "failed to send message to channel '" + channel.getName() + "'");
        }
    }

    protected abstract void validate() throws ConfigurationException;

    protected abstract List<MessageChannel> resolveChannels(Message<?> var1);
}

