/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.springframework.integration.ConfigurationException;
import org.springframework.integration.channel.ChannelRegistry;
import org.springframework.integration.channel.ChannelRegistryAware;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.handler.AbstractMessageHandlerAdapter;
import org.springframework.integration.handler.HandlerMethodInvoker;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHeader;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitterMessageHandlerAdapter<T>
extends AbstractMessageHandlerAdapter<T>
implements ChannelRegistryAware {
    private final Method method;
    private final String outputChannelName;
    private volatile ChannelRegistry channelRegistry;
    private volatile long sendTimeout = -1L;

    public SplitterMessageHandlerAdapter(T object, Method method, Map<String, ?> attributes) {
        Assert.notNull(object, (String)"'object' must not be null");
        Assert.notNull((Object)method, (String)"'method' must not be null");
        Assert.isTrue((attributes != null && attributes.get("outputChannelName") != null ? 1 : 0) != 0, (String)"The 'outputChannelName' attribute is required.");
        this.setObject(object);
        this.setMethodName(method.getName());
        this.method = method;
        this.outputChannelName = (String)attributes.get("outputChannelName");
    }

    @Override
    public void setChannelRegistry(ChannelRegistry channelRegistry) {
        this.channelRegistry = channelRegistry;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    @Override
    protected final Object doHandle(Message<?> message, HandlerMethodInvoker<T> invoker) {
        MessageHeader originalMessageHeader = message.getHeader();
        if (this.method.getParameterTypes().length != 1) {
            throw new ConfigurationException("Splitter method must accept exactly one parameter");
        }
        Object retval = null;
        Class<?> type = this.method.getParameterTypes()[0];
        retval = type.equals(Message.class) ? invoker.invokeMethod(message) : invoker.invokeMethod(message.getPayload());
        if (retval == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Splitter method '" + this.method.getName() + "' returned null"));
            }
            return null;
        }
        if (retval instanceof Collection) {
            Collection items = (Collection)retval;
            int sequenceNumber = 0;
            int sequenceSize = items.size();
            for (Object item : items) {
                Message<?> splitMessage = item instanceof Message ? (Message<?>)item : this.createReplyMessage(item, originalMessageHeader);
                this.prepareMessage(splitMessage, message.getId(), ++sequenceNumber, sequenceSize);
                this.sendMessage(splitMessage, this.outputChannelName);
            }
        } else if (retval.getClass().isArray()) {
            Object[] array = (Object[])retval;
            int sequenceNumber = 0;
            int sequenceSize = array.length;
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                Message<?> splitMessage = item instanceof Message ? (Message<?>)item : this.createReplyMessage(item, originalMessageHeader);
                this.prepareMessage(splitMessage, message.getId(), ++sequenceNumber, sequenceSize);
                this.sendMessage(splitMessage, this.outputChannelName);
                ++n2;
            }
        } else {
            throw new ConfigurationException("splitter method must return either a Collection or array");
        }
        return null;
    }

    private void prepareMessage(Message<?> message, Object correlationId, int sequenceNumber, int sequenceSize) {
        message.getHeader().setCorrelationId(correlationId);
        message.getHeader().setSequenceNumber(sequenceNumber);
        message.getHeader().setSequenceSize(sequenceSize);
    }

    private boolean sendMessage(Message<?> message, String channelName) {
        if (this.channelRegistry == null) {
            throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " requires a ChannelRegistry reference.");
        }
        MessageChannel channel = this.channelRegistry.lookupChannel(channelName);
        if (channel == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("unable to resolve channel for name '" + channelName + "'"));
            }
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sending message to channel '" + channelName + "'"));
        }
        return this.sendTimeout < 0L ? channel.send(message) : channel.send(message, this.sendTimeout);
    }
}

