/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.scheduling;

import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.scheduling.Schedule;
import org.springframework.util.Assert;

public class Subscription {
    private final MessageChannel channel;
    private final String channelName;
    private final Schedule schedule;

    public Subscription(MessageChannel channel) {
        this(channel, null);
    }

    public Subscription(String channelName) {
        this(channelName, null);
    }

    public Subscription(MessageChannel channel, Schedule schedule) {
        Assert.notNull((Object)channel, (String)"'channel' must not be null");
        this.channel = channel;
        this.schedule = schedule;
        this.channelName = this.channel.getName();
    }

    public Subscription(String channelName, Schedule schedule) {
        Assert.notNull((Object)channelName, (String)"'channelName' must not be null");
        this.channelName = channelName;
        this.schedule = schedule;
        this.channel = null;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public String getChannelName() {
        return this.channel != null ? this.channel.getName() : this.channelName;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }
}

