/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.29
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER)
# define _CRT_SECURE_NO_DEPRECATE
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13




#include <MqOai.h>
#include <Mq.h>
#include <WTypes.h>
#include <map>
#include <string>
#include <stdexcept>
#include <iostream>
#include "msmq_native_support.h"


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


typedef signed char ByteArray;

SWIGINTERN ByteArray *new_ByteArray(int nelements){
  return new signed char[nelements];
}
SWIGINTERN void delete_ByteArray(ByteArray *self){
  delete [] self;
}
SWIGINTERN signed char ByteArray_getitem(ByteArray *self,int index){
  return self[index];
}
SWIGINTERN void ByteArray_setitem(ByteArray *self,int index,signed char value){
  self[index] = value;
}
SWIGINTERN signed char *ByteArray_cast(ByteArray *self){
  return self;
}
SWIGINTERN ByteArray *ByteArray_frompointer(signed char *t){
  return (ByteArray *) t;
}

SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <stdexcept>


#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jint JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MQMSG_1DELIVERY_1EXPRESS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 0;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MQMSG_1DELIVERY_1RECOVERABLE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 1;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_PROPID_1M_1CORRELATIONID_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 20;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_PROPID_1M_1MSGID_1SIZE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 20;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MQ_1RECEIVE_1ACCESS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 0x00000001;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MQ_1SEND_1ACCESS_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 0x00000002;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_INFINITE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 0xFFFFFFFF;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_new_1ByteArray(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jlong jresult = 0 ;
  int arg1 ;
  ByteArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (ByteArray *)new_ByteArray(arg1);
  *(ByteArray **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_delete_1ByteArray(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ByteArray *arg1 = (ByteArray *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ByteArray **)&jarg1; 
  delete_ByteArray(arg1);
  
}


JNIEXPORT jbyte JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_ByteArray_1getitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jbyte jresult = 0 ;
  ByteArray *arg1 = (ByteArray *) 0 ;
  int arg2 ;
  signed char result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ByteArray **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (signed char)ByteArray_getitem(arg1,arg2);
  jresult = (jbyte)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_ByteArray_1setitem(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jbyte jarg3) {
  ByteArray *arg1 = (ByteArray *) 0 ;
  int arg2 ;
  signed char arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ByteArray **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (signed char)jarg3; 
  ByteArray_setitem(arg1,arg2,arg3);
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_ByteArray_1cast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  ByteArray *arg1 = (ByteArray *) 0 ;
  signed char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ByteArray **)&jarg1; 
  result = (signed char *)ByteArray_cast(arg1);
  *(signed char **)&jresult = result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_ByteArray_1frompointer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  signed char *arg1 = (signed char *) 0 ;
  ByteArray *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(signed char **)&jarg1; 
  result = (ByteArray *)ByteArray_frompointer(arg1);
  *(ByteArray **)&jresult = result; 
  return jresult;
}


JNIEXPORT jint JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MAXMSGSIZE_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int) 1024;
  
  jresult = (jint)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_new_1MsmqMessage(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  MsmqMessage *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (MsmqMessage *)new MsmqMessage();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  *(MsmqMessage **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_delete_1MsmqMessage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1setAppSpecifc(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setAppSpecifc(arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getAppSpecific(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    try {
      result = (unsigned int)(arg1)->getAppSpecific();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getArrivedTime(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    try {
      result = (unsigned int)(arg1)->getArrivedTime();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1setMsgBody(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  signed char *arg2 = (signed char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  arg2 = *(signed char **)&jarg2; 
  {
    try {
      (arg1)->setMsgBody(arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1setMsgBodyWithByteBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  void *arg2 = (void *) 0 ;
  long arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    /* %typemap(in) void * */
    arg2 = jenv->GetDirectBufferAddress(jarg2);
    arg3 = (long)(jenv->GetDirectBufferCapacity(jarg2));
  }
  {
    try {
      (arg1)->setMsgBodyWithByteBuffer(arg2,arg3);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getBodyType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    try {
      result = (unsigned int)(arg1)->getBodyType();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1setBodySize(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setBodySize(arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getBodySize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    try {
      result = (unsigned int)(arg1)->getBodySize();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1setCorrelationId(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  signed char *arg2 ;
  jbyte *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 20) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInSchar(jenv, &jarr2, &arg2, jarg2)) return ; 
  {
    try {
      (arg1)->setCorrelationId(arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
  SWIG_JavaArrayArgoutSchar(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getCorrelationId(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  signed char *arg2 ;
  jbyte *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 20) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInSchar(jenv, &jarr2, &arg2, jarg2)) return ; 
  {
    try {
      (arg1)->getCorrelationId(arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
  SWIG_JavaArrayArgoutSchar(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1setDelivery(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setDelivery(arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getDelivery(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    try {
      result = (unsigned int)(arg1)->getDelivery();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getMsgId(JNIEnv *jenv, jclass jcls, jlong jarg1, jbyteArray jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  signed char *arg2 ;
  jbyte *jarr2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  if (jarg2 && jenv->GetArrayLength(jarg2) != 20) {
    SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
    return ;
  }
  if (!SWIG_JavaArrayInSchar(jenv, &jarr2, &arg2, jarg2)) return ; 
  {
    try {
      (arg1)->getMsgId(arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
  SWIG_JavaArrayArgoutSchar(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1setPriority(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setPriority(arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getPriority(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    try {
      result = (unsigned int)(arg1)->getPriority();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getSentTime(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    try {
      result = (unsigned int)(arg1)->getSentTime();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1setTimeToBeReceived(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      (arg1)->setTimeToBeReceived(arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqMessage_1getTimeToBeReceived(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  MsmqMessage *arg1 = (MsmqMessage *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqMessage **)&jarg1; 
  {
    try {
      result = (unsigned int)(arg1)->getTimeToBeReceived();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


JNIEXPORT jlong JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_new_1MsmqQueue(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  MsmqQueue *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (MsmqQueue *)new MsmqQueue();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  *(MsmqQueue **)&jresult = result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_delete_1MsmqQueue(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MsmqQueue *arg1 = (MsmqQueue *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqQueue **)&jarg1; 
  {
    try {
      delete arg1;
      
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqQueue_1open(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
  MsmqQueue *arg1 = (MsmqQueue *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqQueue **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (int)jarg3; 
  {
    try {
      (arg1)->open((char const *)arg2,arg3);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2);
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqQueue_1sendMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  MsmqQueue *arg1 = (MsmqQueue *) 0 ;
  MsmqMessage *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqQueue **)&jarg1; 
  arg2 = *(MsmqMessage **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "MsmqMessage const & reference is null");
    return ;
  } 
  {
    try {
      (arg1)->sendMessage((MsmqMessage const &)*arg2);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT jboolean JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqQueue_1receiveMessage(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jboolean jresult = 0 ;
  MsmqQueue *arg1 = (MsmqQueue *) 0 ;
  MsmqMessage arg2 ;
  int arg3 ;
  bool result;
  MsmqMessage *argp2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqQueue **)&jarg1; 
  argp2 = *(MsmqMessage **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null MsmqMessage");
    return 0;
  }
  arg2 = *argp2; 
  arg3 = (int)jarg3; 
  {
    try {
      result = (bool)(arg1)->receiveMessage(arg2,arg3);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqQueue_1close(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  MsmqQueue *arg1 = (MsmqQueue *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqQueue **)&jarg1; 
  {
    try {
      (arg1)->close();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
}


JNIEXPORT jboolean JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqQueue_1isOpen(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jboolean jresult = 0 ;
  MsmqQueue *arg1 = (MsmqQueue *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(MsmqQueue **)&jarg1; 
  {
    try {
      result = (bool)((MsmqQueue const *)arg1)->isOpen();
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return 0; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqQueue_1createQueue(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  {
    try {
      MsmqQueue::createQueue(arg1);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
}


JNIEXPORT void JNICALL Java_org_apache_camel_component_msmq_native_1support_msmq_1native_1supportJNI_MsmqQueue_1deleteQueue(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  char *arg1 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  {
    try {
      MsmqQueue::deleteQueue(arg1);
    } catch(const std::runtime_error& e) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, e.what()); return ; 
      };
    } catch(...) {
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, "Unknown exception"); return ; 
      };
    }
  }
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1);
}


#ifdef __cplusplus
}
#endif

