/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.file.remote;

import java.io.ByteArrayOutputStream;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.impl.DefaultExchange;

public class RemoteFileExchange<T extends RemoteFileBinding> extends DefaultExchange {
    private T binding;

    public RemoteFileExchange(CamelContext context, ExchangePattern pattern, T binding) {
        super(context, pattern);
        this.binding = binding;
    }

    public RemoteFileExchange(CamelContext context, ExchangePattern pattern, T binding, String host, 
                              String fullFileName, String fileName, long fileLength, ByteArrayOutputStream outputStream) {
        this(context, pattern, binding);
        setIn(new RemoteFileMessage(host, fullFileName, fileName, fileLength, outputStream));
    }

    public T getBinding() {
        return binding;
    }

    public void setBinding(T binding) {
        this.binding = binding;
    }
}
