/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.jmxconnect.provider.activemq;

import org.apache.camel.jmxconnect.CamelJmxConnector;
import org.apache.camel.jmxconnect.CamelJmxConnectorSupport;
import org.apache.camel.CamelContext;

import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import java.io.IOException;
import java.util.Map;

/**
 * @version $Revision: 47316 $
 */
public class ClientProvider implements JMXConnectorProvider {
    public JMXConnector newJMXConnector(JMXServiceURL url, Map environment) throws IOException {
        // use the remaining url as the ActiveMQ broker URI
        String brokerUrl = CamelJmxConnectorSupport.getEndpointUri(url, "activemq");
        CamelJmxConnector answer = new CamelJmxConnector(environment, ActiveMQHelper.getDefaultEndpointUri());

        // now lets configure the ActiveMQ component
        CamelContext camelContext = answer.getCamelContext();
        ActiveMQHelper.configureActiveMQComponent(camelContext, brokerUrl);
        return answer;
    }

}
