/*
	Copyright (c) 2004-2009, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["dojox.gfx.matrix"]){dojo._hasResource["dojox.gfx.matrix"]=true;dojo.provide("dojox.gfx.matrix");(function(){var m=dojox.gfx.matrix;m._degToRad=function(_2){return Math.PI*_2/180;};m._radToDeg=function(_3){return _3/Math.PI*180;};m.Matrix2D=function(_4){if(_4){if(typeof _4=="number"){this.xx=this.yy=_4;}else{if(_4 instanceof Array){if(_4.length>0){var _5=m.normalize(_4[0]);for(var i=1;i<_4.length;++i){var l=_5,r=dojox.gfx.matrix.normalize(_4[i]);_5=new m.Matrix2D();_5.xx=l.xx*r.xx+l.xy*r.yx;_5.xy=l.xx*r.xy+l.xy*r.yy;_5.yx=l.yx*r.xx+l.yy*r.yx;_5.yy=l.yx*r.xy+l.yy*r.yy;_5.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_5.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}dojo.mixin(this,_5);}}else{dojo.mixin(this,_4);}}}};dojo.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});dojo.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_d){var c=Math.cos(_d);var s=Math.sin(_d);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_10){return m.rotate(m._degToRad(_10));},skewX:function(_11){return new m.Matrix2D({xy:Math.tan(_11)});},skewXg:function(_12){return m.skewX(m._degToRad(_12));},skewY:function(_13){return new m.Matrix2D({yx:Math.tan(_13)});},skewYg:function(_14){return m.skewY(m._degToRad(_14));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_21){return (_21 instanceof m.Matrix2D)?_21:new m.Matrix2D(_21);},clone:function(_22){var obj=new m.Matrix2D();for(var i in _22){if(typeof (_22[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_22[i]){obj[i]=_22[i];}}return obj;},invert:function(_25){var M=m.normalize(_25),D=M.xx*M.yy-M.xy*M.yx,M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_28,x,y){return {x:_28.xx*x+_28.xy*y+_28.dx,y:_28.yx*x+_28.yy*y+_28.dy};},multiplyPoint:function(_2b,a,b){var M=m.normalize(_2b);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiply:function(_2f){var M=m.normalize(_2f);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_34,x,y){return m.multiply(m.translate(x,y),_34,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_3b,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_3b),a,b);}return m._sandwich(m.rotate(_3b),a.x,a.y);},rotategAt:function(_3e,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_3e),a,b);}return m._sandwich(m.rotateg(_3e),a.x,a.y);},skewXAt:function(_41,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_41),a,b);}return m._sandwich(m.skewX(_41),a.x,a.y);},skewXgAt:function(_44,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_44),a,b);}return m._sandwich(m.skewXg(_44),a.x,a.y);},skewYAt:function(_47,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_47),a,b);}return m._sandwich(m.skewY(_47),a.x,a.y);},skewYgAt:function(_4a,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_4a),a,b);}return m._sandwich(m.skewYg(_4a),a.x,a.y);}});})();dojox.gfx.Matrix2D=dojox.gfx.matrix.Matrix2D;}if(!dojo._hasResource["dojox.gfx._base"]){dojo._hasResource["dojox.gfx._base"]=true;dojo.provide("dojox.gfx._base");(function(){var g=dojox.gfx,b=g._base;g._hasClass=function(_4f,_50){var cls=_4f.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_50+" ")>=0;};g._addClass=function(_52,_53){var cls=_52.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_53+" ")<0){_52.setAttribute("className",cls+(cls?" ":"")+_53);}};g._removeClass=function(_55,_56){var cls=_55.getAttribute("className");if(cls){_55.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_56+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _58={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};if(dojo.isIE){dojo.doc.documentElement.style.fontSize="100%";}var div=dojo.doc.createElement("div");div.style.position="absolute";div.style.left="-100px";div.style.top="0";div.style.width="30px";div.style.height="1000em";div.style.border="0";div.style.margin="0";div.style.padding="0";div.style.outline="0";div.style.lineHeight="1";div.style.overflow="hidden";dojo.body().appendChild(div);for(var p in _58){div.style.fontSize=p;_58[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}dojo.body().removeChild(div);div=null;return _58;};var _5b=null;b._getCachedFontMeasurements=function(_5c){if(_5c||!_5b){_5b=b._getFontMeasurements();}return _5b;};var _5d=null,_5e={};b._getTextBox=function(_5f,_60,_61){var m;if(!_5d){m=_5d=dojo.doc.createElement("div");m.style.position="absolute";m.style.left="-10000px";m.style.top="0";dojo.body().appendChild(m);}else{m=_5d;}m.className="";m.style.border="0";m.style.margin="0";m.style.padding="0";m.style.outline="0";if(arguments.length>1&&_60){for(var i in _60){if(i in _5e){continue;}m.style[i]=_60[i];}}if(arguments.length>2&&_61){m.className=_61;}m.innerHTML=_5f;return dojo.marginBox(m);};var _64=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"Unique"+(++_64);}while(dojo.byId(id));return id;};})();dojo.mixin(dojox.gfx,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},normalizeColor:function(_66){return (_66 instanceof dojo.Color)?_66:new dojo.Color(_66);},normalizeParameters:function(_67,_68){if(_68){var _69={};for(var x in _67){if(x in _68&&!(x in _69)){_67[x]=_68[x];}}}return _67;},makeParameters:function(_6b,_6c){if(!_6c){return dojo.clone(_6b);}var _6d={};for(var i in _6b){if(!(i in _6d)){_6d[i]=dojo.clone((i in _6c)?_6c[i]:_6b[i]);}}return _6d;},formatNumber:function(x,_70){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _72=val.indexOf(".");if(_72>=0&&val.length-_72>5){val=x.toFixed(4);}}if(x<0){return val;}return _70?" "+val:val;},makeFontString:function(_73){return _73.style+" "+_73.variant+" "+_73.weight+" "+_73.size+" "+_73.family;},splitFontString:function(str){var _75=dojo.clone(dojox.gfx.defaultFont);var t=str.split(/\s+/);do{if(t.length<5){break;}_75.style=t[0];_75.varian=t[1];_75.weight=t[2];var i=t[3].indexOf("/");_75.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;break;}if(t[4].substr(0,1)=="/"){j=5;break;}}if(j+3>t.length){break;}_75.size=t[j];_75.family=t[j+1];}while(false);return _75;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return dojox.gfx._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*dojox.gfx.px_in_pt();},px2pt:function(len){return len/dojox.gfx.px_in_pt();},normalizedLength:function(len){if(len.length==0){return 0;}if(len.length>2){var _7c=dojox.gfx.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_7c;case "in":return val*72*_7c;case "pc":return val*12*_7c;case "mm":return val*dojox.gfx.mm_in_pt*_7c;case "cm":return val*dojox.gfx.cm_in_pt*_7c;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a==b;}});}if(!dojo._hasResource["dojox.gfx"]){dojo._hasResource["dojox.gfx"]=true;dojo.provide("dojox.gfx");dojo.loadInit(function(){var gfx=dojo.getObject("dojox.gfx",true),sl,_82,_83;if(!gfx.renderer){var _84=(typeof dojo.config.gfxRenderer=="string"?dojo.config.gfxRenderer:"svg,vml,silverlight,canvas").split(",");var ua=navigator.userAgent,_86=0,_87=0;if(dojo.isSafari>=3){if(ua.indexOf("iPhone")>=0||ua.indexOf("iPod")>=0){_83=ua.match(/Version\/(\d(\.\d)?(\.\d)?)\sMobile\/([^\s]*)\s?/);if(_83){_86=parseInt(_83[4].substr(0,3),16);}}}if(dojo.isWebKit){if(!_86){_83=ua.match(/Android\s+(\d+\.\d+)/);if(_83){_87=parseFloat(_83[1]);}}}for(var i=0;i<_84.length;++i){switch(_84[i]){case "svg":if(!dojo.isIE&&(!_86||_86>=1521)&&!_87&&!dojo.isAIR){dojox.gfx.renderer="svg";}break;case "vml":if(dojo.isIE){dojox.gfx.renderer="vml";}break;case "silverlight":try{if(dojo.isIE){sl=new ActiveXObject("AgControl.AgControl");if(sl&&sl.IsVersionSupported("1.0")){_82=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_82=true;}}}catch(e){_82=false;}finally{sl=null;}if(_82){dojox.gfx.renderer="silverlight";}break;case "canvas":if(!dojo.isIE){dojox.gfx.renderer="canvas";}break;}if(dojox.gfx.renderer){break;}}if(dojo.config.isDebug){}}});dojo.requireIf(dojox.gfx.renderer=="svg","dojox.gfx.svg");dojo.requireIf(dojox.gfx.renderer=="vml","dojox.gfx.vml");dojo.requireIf(dojox.gfx.renderer=="silverlight","dojox.gfx.silverlight");dojo.requireIf(dojox.gfx.renderer=="canvas","dojox.gfx.canvas");}if(!dojo._hasResource["dojox.lang.functional.lambda"]){dojo._hasResource["dojox.lang.functional.lambda"]=true;dojo.provide("dojox.lang.functional.lambda");(function(){var df=dojox.lang.functional,_8a={};var _8b="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _8f=function(s){var _91=[],_92=_8b.call(s,/\s*->\s*/m);if(_92.length>1){while(_92.length){s=_92.pop();_91=_92.pop().split(/\s*,\s*|\s+/m);if(_92.length){_92.push("(function("+_91+"){return ("+s+")})");}}}else{if(s.match(/\b_\b/)){_91=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_91.push("$1");s="$1"+s;}if(r){_91.push("$2");s=s+"$2";}}else{var _95=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};dojo.forEach(_95,function(v){if(!(v in t)){_91.push(v);t[v]=1;}});}}}return {args:_91,body:s};};var _98=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};dojo.mixin(df,{rawLambda:function(s){return _8f(s);},buildLambda:function(s){s=_8f(s);return "function("+s.args.join(",")+"){return ("+s.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _98(s);}if(s in _8a){return _8a[s];}s=_8f(s);return _8a[s]=new Function(s.args,"return ("+s.body+");");},clearLambdaCache:function(){_8a={};}});})();}if(!dojo._hasResource["dojox.lang.functional.array"]){dojo._hasResource["dojox.lang.functional.array"]=true;dojo.provide("dojox.lang.functional.array");(function(){var d=dojo,df=dojox.lang.functional,_a2={};d.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t=[],v,i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _a2)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _a2)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _a2)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _a2)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _a2)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});})();}if(!dojo._hasResource["dojox.lang.functional.object"]){dojo._hasResource["dojox.lang.functional.object"]=true;dojo.provide("dojox.lang.functional.object");(function(){var d=dojo,df=dojox.lang.functional,_c1={};d.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _c1)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _c1)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _c1)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);for(var i in obj){if(!(i in _c1)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _c1)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});})();}if(!dojo._hasResource["dojox.lang.functional"]){dojo._hasResource["dojox.lang.functional"]=true;dojo.provide("dojox.lang.functional");}if(!dojo._hasResource["dojox.lang.functional.fold"]){dojo._hasResource["dojox.lang.functional.fold"]=true;dojo.provide("dojox.lang.functional.fold");(function(){var d=dojo,df=dojox.lang.functional,_d9={};d.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _d9)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var z,i,n;if(d.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _e6=true;for(i in a){if(!(i in _d9)){if(_e6){z=a[i];_e6=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||d.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});})();}if(!dojo._hasResource["dojox.lang.functional.reversed"]){dojo._hasResource["dojox.lang.functional.reversed"]=true;dojo.provide("dojox.lang.functional.reversed");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});})();}if(!dojo._hasResource["dojo.colors"]){dojo._hasResource["dojo.colors"]=true;dojo.provide("dojo.colors");(function(){var _119=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=function(_11e,obj){var m=_11e.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=dojo.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return dojo.colorFromArray(a,obj);}return dojo.colorFromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_119(m1,m2,H+1/3)*256,_119(m1,m2,H)*256,_119(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return dojo.colorFromArray(a,obj);}}return null;};var _12c=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};dojo.Color.prototype.sanitize=function(){var t=this;t.r=Math.round(_12c(t.r,0,255));t.g=Math.round(_12c(t.g,0,255));t.b=Math.round(_12c(t.b,0,255));t.a=_12c(t.a,0,1);return this;};})();dojo.colors.makeGrey=function(g,a){return dojo.colorFromArray([g,g,g,a]);};dojo.mixin(dojo.Color.named,{aliceblue:[240,248,255],antiquewhite:[250,235,215],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],blanchedalmond:[255,235,205],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],oldlace:[253,245,230],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],thistle:[216,191,216],tomato:[255,99,71],transparent:[0,0,0,0],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],whitesmoke:[245,245,245],yellowgreen:[154,205,50]});}if(!dojo._hasResource["dojox.color._base"]){dojo._hasResource["dojox.color._base"]=true;dojo.provide("dojox.color._base");dojox.color.Color=dojo.Color;dojox.color.blend=dojo.blendColors;dojox.color.fromRgb=dojo.colorFromRgb;dojox.color.fromHex=dojo.colorFromHex;dojox.color.fromArray=dojo.colorFromArray;dojox.color.fromString=dojo.colorFromString;dojox.color.greyscale=dojo.colors.makeGrey;dojo.mixin(dojox.color,{fromCmy:function(cyan,_134,_135){if(dojo.isArray(cyan)){_134=cyan[1],_135=cyan[2],cyan=cyan[0];}else{if(dojo.isObject(cyan)){_134=cyan.m,_135=cyan.y,cyan=cyan.c;}}cyan/=100,_134/=100,_135/=100;var r=1-cyan,g=1-_134,b=1-_135;return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_13a,_13b,_13c){if(dojo.isArray(cyan)){_13a=cyan[1],_13b=cyan[2],_13c=cyan[3],cyan=cyan[0];}else{if(dojo.isObject(cyan)){_13a=cyan.m,_13b=cyan.y,_13c=cyan.b,cyan=cyan.c;}}cyan/=100,_13a/=100,_13b/=100,_13c/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_13c)+_13c);g=1-Math.min(1,_13a*(1-_13c)+_13c);b=1-Math.min(1,_13b*(1-_13c)+_13c);return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_141,_142){if(dojo.isArray(hue)){_141=hue[1],_142=hue[2],hue=hue[0];}else{if(dojo.isObject(hue)){_141=hue.s,_142=hue.l,hue=hue.h;}}_141/=100;_142/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_141*Math.min(r,1)+(1-_141);g=2*_141*Math.min(g,1)+(1-_141);b=2*_141*Math.min(b,1)+(1-_141);if(_142<0.5){r*=_142,g*=_142,b*=_142;}else{r=(1-_142)*r+2*_142-1;g=(1-_142)*g+2*_142-1;b=(1-_142)*b+2*_142-1;}return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsv:function(hue,_147,_148){if(dojo.isArray(hue)){_147=hue[1],_148=hue[2],hue=hue[0];}else{if(dojo.isObject(hue)){_147=hue.s,_148=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_147/=100;_148/=100;var r,g,b;if(_147==0){r=_148,b=_148,g=_148;}else{var _14c=hue/60,i=Math.floor(_14c),f=_14c-i;var p=_148*(1-_147);var q=_148*(1-(_147*f));var t=_148*(1-(_147*(1-f)));switch(i){case 0:r=_148,g=t,b=p;break;case 1:r=q,g=_148,b=p;break;case 2:r=p,g=_148,b=t;break;case 3:r=p,g=q,b=_148;break;case 4:r=t,g=p,b=_148;break;case 5:r=_148,g=p,b=q;break;}}return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});dojo.extend(dojox.color.Color,{toCmy:function(){var cyan=1-(this.r/255),_153=1-(this.g/255),_154=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_153*100),y:Math.round(_154*100)};},toCmyk:function(){var cyan,_156,_157,_158;var r=this.r/255,g=this.g/255,b=this.b/255;_158=Math.min(1-r,1-g,1-b);cyan=(1-r-_158)/(1-_158);_156=(1-g-_158)/(1-_158);_157=(1-b-_158)/(1-_158);return {c:Math.round(cyan*100),m:Math.round(_156*100),y:Math.round(_157*100),b:Math.round(_158*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _161=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_161/((l<0.5)?(2*l):(2-2*l));}if(_161>0){if(max==r&&max!=g){h+=(g-b)/_161;}if(max==g&&max!=b){h+=(2+(b-r)/_161);}if(max==b&&max!=r){h+=(4+(r-g)/_161);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _16a=max-min;var h=null,s=(max==0)?0:(_16a/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_16a;}else{if(g==max){h=120+60*(b-r)/_16a;}else{h=240+60*(r-g)/_16a;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});}if(!dojo._hasResource["dojox.color"]){dojo._hasResource["dojox.color"]=true;dojo.provide("dojox.color");}if(!dojo._hasResource["dojox.color.Palette"]){dojo._hasResource["dojox.color.Palette"]=true;dojo.provide("dojox.color.Palette");(function(){var dxc=dojox.color;dxc.Palette=function(base){this.colors=[];if(base instanceof dojox.color.Palette){this.colors=base.colors.slice(0);}else{if(base instanceof dojox.color.Color){this.colors=[null,null,base,null,null];}else{if(dojo.isArray(base)){this.colors=dojo.map(base.slice(0),function(item){if(dojo.isString(item)){return new dojox.color.Color(item);}return item;});}else{if(dojo.isString(base)){this.colors=[null,null,new dojox.color.Color(base),null,null];}}}}};function _170(p,_172,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var r=(_172=="dr")?item.r+val:item.r,g=(_172=="dg")?item.g+val:item.g,b=(_172=="db")?item.b+val:item.b,a=(_172=="da")?item.a+val:item.a;ret.colors.push(new dojox.color.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;};function tCMY(p,_17c,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toCmy(),c=(_17c=="dc")?o.c+val:o.c,m=(_17c=="dm")?o.m+val:o.m,y=(_17c=="dy")?o.y+val:o.y;ret.colors.push(dojox.color.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function _184(p,_186,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toCmyk(),c=(_186=="dc")?o.c+val:o.c,m=(_186=="dm")?o.m+val:o.m,y=(_186=="dy")?o.y+val:o.y,k=(_186=="dk")?o.b+val:o.b;ret.colors.push(dojox.color.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function tHSL(p,_191,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toHsl(),h=(_191=="dh")?o.h+val:o.h,s=(_191=="ds")?o.s+val:o.s,l=(_191=="dl")?o.l+val:o.l;ret.colors.push(dojox.color.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function tHSV(p,_19b,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toHsv(),h=(_19b=="dh")?o.h+val:o.h,s=(_19b=="ds")?o.s+val:o.s,v=(_19b=="dv")?o.v+val:o.v;ret.colors.push(dojox.color.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _1a3(val,low,high){return high-((high-val)*((high-low)/high));};dojo.extend(dxc.Palette,{transform:function(_1a7){var fn=_170;if(_1a7.use){var use=_1a7.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=tHSL;}else{fn=tHSV;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=_184;}else{fn=tCMY;}}}}else{if("dc" in _1a7||"dm" in _1a7||"dy" in _1a7){if("dk" in _1a7){fn=_184;}else{fn=tCMY;}}else{if("dh" in _1a7||"ds" in _1a7){if("dv" in _1a7){fn=tHSV;}else{fn=tHSL;}}}}var _1aa=this;for(var p in _1a7){if(p=="use"){continue;}_1aa=fn(_1aa,p,_1a7[p]);}return _1aa;},clone:function(){return new dxc.Palette(this);}});dojo.mixin(dxc.Palette,{generators:{analogous:function(args){var high=args.high||60,low=args.low||18,base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(high/2)+360)%360,(hsv.h-high+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(dojo.map(h,function(hue,i){return dojox.color.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_1a3(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v3),base,dojox.color.fromHsv(hsv.h,s1,v3),dojox.color.fromHsv(hsv.h,s2,v2)]);},triadic:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,hsv.v),dojox.color.fromHsv(hsv.h,s2,v2),base,dojox.color.fromHsv(h2,s2,v1),dojox.color.fromHsv(h2,s3,v3)]);},complementary:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_1a3(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v2),base,dojox.color.fromHsv(h1,s3,v2),dojox.color.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,_1d8=args.da||30,hsv=base.toHsv();var _1da=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(_1da-_1d8+360)%360,h2=(_1da+_1d8)%360,s1=Math.max(hsv.s-10,0),s2=_1a3(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),base,dojox.color.fromHsv(h2,s3,v2),dojox.color.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),base,dojox.color.fromHsv(h2,s3,v3),dojox.color.fromHsv(h3,s2,v2)]);},shades:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dojox.color.fromHsv(hsv.h,s,v1),new dojox.color.fromHsv(hsv.h,s,v2),base,new dojox.color.fromHsv(hsv.h,s,v3),new dojox.color.fromHsv(hsv.h,s,v4)]);}},generate:function(base,type){if(dojo.isFunction(type)){return type({base:base});}else{if(dxc.Palette.generators[type]){return dxc.Palette.generators[type]({base:base});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+type+"') does not exist.");}});})();}if(!dojo._hasResource["dojox.charting.Theme"]){dojo._hasResource["dojox.charting.Theme"]=true;dojo.provide("dojox.charting.Theme");(function(){var dxc=dojox.charting;dxc.Theme=function(_1f9){_1f9=_1f9||{};var def=dxc.Theme._def;dojo.forEach(["chart","plotarea","axis","series","marker"],function(n){this[n]=dojo.delegate(def[n],_1f9[n]||{});},this);this.markers=dojo.delegate(dxc.Theme.Markers,_1f9.markers||{});this.colors=[];this.antiAlias=("antiAlias" in _1f9)?_1f9.antiAlias:true;this.assignColors=("assignColors" in _1f9)?_1f9.assignColors:true;this.assignMarkers=("assignMarkers" in _1f9)?_1f9.assignMarkers:true;_1f9.colors=_1f9.colors||def.colors;dojo.forEach(_1f9.colors,function(item){this.colors.push(item);},this);this._current={color:0,marker:0};this._markers=[];this._buildMarkerArray();};dxc.Theme.Markers={CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"};dxc.Theme._def={chart:{stroke:null,fill:"white"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},majorTick:{color:"#666",width:1,length:6,position:"center"},minorTick:{color:"#666",width:0.8,length:3,position:"center"},font:"normal normal normal 7pt Tahoma",fontColor:"#333"},series:{outline:{width:0.1,color:"#ccc"},stroke:{width:1.5,color:"#333"},fill:"#ccc",font:"normal normal normal 7pt Tahoma",fontColor:"#000"},marker:{stroke:{width:1},fill:"#333",font:"normal normal normal 7pt Tahoma",fontColor:"#000"},colors:["#54544c","#858e94","#6e767a","#948585","#474747"]};dojo.extend(dxc.Theme,{defineColors:function(obj){var _1fe=obj||{};var c=[],n=_1fe.num||5;if(_1fe.colors){var l=_1fe.colors.length;for(var i=0;i<n;i++){c.push(_1fe.colors[i%l]);}this.colors=c;}else{if(_1fe.hue){var s=_1fe.saturation||100;var st=_1fe.low||30;var end=_1fe.high||90;var l=(end+st)/2;this.colors=dojox.color.Palette.generate(dojox.color.fromHsv(_1fe.hue,s,l),"monochromatic").colors;}else{if(_1fe.generator){this.colors=dojox.color.Palette.generate(_1fe.base,_1fe.generator).colors;}}}},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}this._current.marker=0;},_clone:function(){return new dxc.Theme({chart:this.chart,plotarea:this.plotarea,axis:this.axis,series:this.series,marker:this.marker,antiAlias:this.antiAlias,assignColors:this.assignColors,assignMarkers:this.assigneMarkers,colors:dojo.delegate(this.colors)});},addMarker:function(name,_208){this.markers[name]=_208;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},next:function(type){if(type=="marker"){return this._markers[this._current.marker++%this._markers.length];}else{return this.colors[this._current.color++%this.colors.length];}},clear:function(){this._current={color:0,marker:0};}});})();}if(!dojo._hasResource["dojox.charting.Element"]){dojo._hasResource["dojox.charting.Element"]=true;dojo.provide("dojox.charting.Element");dojo.declare("dojox.charting.Element",null,{constructor:function(_20b){this.chart=_20b;this.group=null;this.htmlElements=[];this.dirty=true;},createGroup:function(_20c){if(!_20c){_20c=this.chart.surface;}if(!this.group){this.group=_20c.createGroup();}return this;},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.group.clear();this.group.removeShape();this.group=null;}this.dirty=true;return this;},cleanGroup:function(_20d){this.destroyHtmlElements();if(!_20d){_20d=this.chart.surface;}if(this.group){this.group.clear();}else{this.group=_20d.createGroup();}this.dirty=true;return this;},destroyHtmlElements:function(){if(this.htmlElements.length){dojo.forEach(this.htmlElements,dojo.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();}});}if(!dojo._hasResource["dojox.charting.Series"]){dojo._hasResource["dojox.charting.Series"]=true;dojo.provide("dojox.charting.Series");dojo.declare("dojox.charting.Series",dojox.charting.Element,{constructor:function(_20e,data,_210){dojo.mixin(this,_210);if(typeof this.plot!="string"){this.plot="default";}this.data=data;this.dirty=true;this.clear();},clear:function(){this.dyn={};}});}if(!dojo._hasResource["dojox.charting.scaler.common"]){dojo._hasResource["dojox.charting.scaler.common"]=true;dojo.provide("dojox.charting.scaler.common");(function(){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};dojo.mixin(dojox.charting.scaler.common,{findString:function(val,text){val=val.toLowerCase();for(var i=0;i<text.length;++i){if(val==text[i]){return true;}}return false;},getNumericLabel:function(_217,_218,_219){var def=_219.fixed?_217.toFixed(_218<0?-_218:0):_217.toString();if(_219.labelFunc){var r=_219.labelFunc(def,_217,_218);if(r){return r;}}if(_219.labels){var l=_219.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_217){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_217)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_217)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_217)){return l[lo].text;}}return def;}});})();}if(!dojo._hasResource["dojox.charting.scaler.linear"]){dojo._hasResource["dojox.charting.scaler.linear"]=true;dojo.provide("dojox.charting.scaler.linear");(function(){var _221=3,dc=dojox.charting,dcs=dc.scaler,dcsc=dcs.common,_225=dcsc.findString,_226=dcsc.getNumericLabel;var _227=function(min,max,_22a,_22b,_22c,_22d,span){_22a=dojo.delegate(_22a);if(!_22b){if(_22a.fixUpper=="major"){_22a.fixUpper="minor";}if(_22a.fixLower=="major"){_22a.fixLower="minor";}}if(!_22c){if(_22a.fixUpper=="minor"){_22a.fixUpper="micro";}if(_22a.fixLower=="minor"){_22a.fixLower="micro";}}if(!_22d){if(_22a.fixUpper=="micro"){_22a.fixUpper="none";}if(_22a.fixLower=="micro"){_22a.fixLower="none";}}var _22f=_225(_22a.fixLower,["major"])?Math.floor(_22a.min/_22b)*_22b:_225(_22a.fixLower,["minor"])?Math.floor(_22a.min/_22c)*_22c:_225(_22a.fixLower,["micro"])?Math.floor(_22a.min/_22d)*_22d:_22a.min,_230=_225(_22a.fixUpper,["major"])?Math.ceil(_22a.max/_22b)*_22b:_225(_22a.fixUpper,["minor"])?Math.ceil(_22a.max/_22c)*_22c:_225(_22a.fixUpper,["micro"])?Math.ceil(_22a.max/_22d)*_22d:_22a.max;if(_22a.useMin){min=_22f;}if(_22a.useMax){max=_230;}var _231=(!_22b||_22a.useMin&&_225(_22a.fixLower,["major"]))?min:Math.ceil(min/_22b)*_22b,_232=(!_22c||_22a.useMin&&_225(_22a.fixLower,["major","minor"]))?min:Math.ceil(min/_22c)*_22c,_233=(!_22d||_22a.useMin&&_225(_22a.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_22d)*_22d,_234=!_22b?0:(_22a.useMax&&_225(_22a.fixUpper,["major"])?Math.round((max-_231)/_22b):Math.floor((max-_231)/_22b))+1,_235=!_22c?0:(_22a.useMax&&_225(_22a.fixUpper,["major","minor"])?Math.round((max-_232)/_22c):Math.floor((max-_232)/_22c))+1,_236=!_22d?0:(_22a.useMax&&_225(_22a.fixUpper,["major","minor","micro"])?Math.round((max-_233)/_22d):Math.floor((max-_233)/_22d))+1,_237=_22c?Math.round(_22b/_22c):0,_238=_22d?Math.round(_22c/_22d):0,_239=_22b?Math.floor(Math.log(_22b)/Math.LN10):0,_23a=_22c?Math.floor(Math.log(_22c)/Math.LN10):0,_23b=span/(max-min);if(!isFinite(_23b)){_23b=1;}return {bounds:{lower:_22f,upper:_230,from:min,to:max,scale:_23b,span:span},major:{tick:_22b,start:_231,count:_234,prec:_239},minor:{tick:_22c,start:_232,count:_235,prec:_23a},micro:{tick:_22d,start:_233,count:_236,prec:0},minorPerMajor:_237,microPerMinor:_238,scaler:dcs.linear};};dojo.mixin(dojox.charting.scaler.linear,{buildScaler:function(min,max,span,_23f){var h={fixUpper:"none",fixLower:"none",natural:false};if(_23f){if("fixUpper" in _23f){h.fixUpper=String(_23f.fixUpper);}if("fixLower" in _23f){h.fixLower=String(_23f.fixLower);}if("natural" in _23f){h.natural=Boolean(_23f.natural);}}if("min" in _23f){min=_23f.min;}if("max" in _23f){max=_23f.max;}if(_23f.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _23f){min=_23f.from;h.useMin=false;}if("to" in _23f){max=_23f.to;h.useMax=false;}if(max<=min){return _227(min,max,h,0,0,0,span);}var mag=Math.floor(Math.log(max-min)/Math.LN10),_242=_23f&&("majorTickStep" in _23f)?_23f.majorTickStep:Math.pow(10,mag),_243=0,_244=0,_245;if(_23f&&("minorTickStep" in _23f)){_243=_23f.minorTickStep;}else{do{_243=_242/10;if(!h.natural||_243>0.9){_245=_227(min,max,h,_242,_243,0,span);if(_245.bounds.scale*_245.minor.tick>_221){break;}}_243=_242/5;if(!h.natural||_243>0.9){_245=_227(min,max,h,_242,_243,0,span);if(_245.bounds.scale*_245.minor.tick>_221){break;}}_243=_242/2;if(!h.natural||_243>0.9){_245=_227(min,max,h,_242,_243,0,span);if(_245.bounds.scale*_245.minor.tick>_221){break;}}return _227(min,max,h,_242,0,0,span);}while(false);}if(_23f&&("microTickStep" in _23f)){_244=_23f.microTickStep;_245=_227(min,max,h,_242,_243,_244,span);}else{do{_244=_243/10;if(!h.natural||_244>0.9){_245=_227(min,max,h,_242,_243,_244,span);if(_245.bounds.scale*_245.micro.tick>_221){break;}}_244=_243/5;if(!h.natural||_244>0.9){_245=_227(min,max,h,_242,_243,_244,span);if(_245.bounds.scale*_245.micro.tick>_221){break;}}_244=_243/2;if(!h.natural||_244>0.9){_245=_227(min,max,h,_242,_243,_244,span);if(_245.bounds.scale*_245.micro.tick>_221){break;}}_244=0;}while(false);}return _244?_245:_227(min,max,h,_242,_243,0,span);},buildTicks:function(_246,_247){var step,next,tick,_24b=_246.major.start,_24c=_246.minor.start,_24d=_246.micro.start;if(_247.microTicks&&_246.micro.tick){step=_246.micro.tick,next=_24d;}else{if(_247.minorTicks&&_246.minor.tick){step=_246.minor.tick,next=_24c;}else{if(_246.major.tick){step=_246.major.tick,next=_24b;}else{return null;}}}var _24e=1/_246.bounds.scale;if(_246.bounds.to<=_246.bounds.from||isNaN(_24e)||!isFinite(_24e)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _24f=[],_250=[],_251=[];while(next<=_246.bounds.to+_24e){if(Math.abs(_24b-next)<step/2){tick={value:_24b};if(_247.majorLabels){tick.label=_226(_24b,_246.major.prec,_247);}_24f.push(tick);_24b+=_246.major.tick;_24c+=_246.minor.tick;_24d+=_246.micro.tick;}else{if(Math.abs(_24c-next)<step/2){if(_247.minorTicks){tick={value:_24c};if(_247.minorLabels&&(_246.minMinorStep<=_246.minor.tick*_246.bounds.scale)){tick.label=_226(_24c,_246.minor.prec,_247);}_250.push(tick);}_24c+=_246.minor.tick;_24d+=_246.micro.tick;}else{if(_247.microTicks){_251.push({value:_24d});}_24d+=_246.micro.tick;}}next+=step;}return {major:_24f,minor:_250,micro:_251};},getTransformerFromModel:function(_252){var _253=_252.bounds.from,_254=_252.bounds.scale;return function(x){return (x-_253)*_254;};},getTransformerFromPlot:function(_256){var _257=_256.bounds.from,_258=_256.bounds.scale;return function(x){return x/_258+_257;};}});})();}if(!dojo._hasResource["dojox.charting.axis2d.common"]){dojo._hasResource["dojox.charting.axis2d.common"]=true;dojo.provide("dojox.charting.axis2d.common");(function(){var g=dojox.gfx;function _25b(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};dojo.mixin(dojox.charting.axis2d.common,{createText:{gfx:function(_25d,_25e,x,y,_261,text,font,_264){return _25e.createText({x:x,y:y,text:text,align:_261}).setFont(font).setFill(_264);},html:function(_265,_266,x,y,_269,text,font,_26c){var p=dojo.doc.createElement("div"),s=p.style;_25b(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_26c;s.position="absolute";s.left="-10000px";dojo.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size),box=dojo.marginBox(p);dojo.body().removeChild(p);s.position="relative";switch(_269){case "middle":s.left=Math.floor(x-box.w/2)+"px";break;case "end":s.left=Math.floor(x-box.w)+"px";break;default:s.left=Math.floor(x)+"px";break;}s.top=Math.floor(y-size)+"px";var wrap=dojo.doc.createElement("div"),w=wrap.style;_25b(w);w.width="0px";w.height="0px";wrap.appendChild(p);_265.node.insertBefore(wrap,_265.node.firstChild);return wrap;}}});})();}if(!dojo._hasResource["dojox.charting.axis2d.Base"]){dojo._hasResource["dojox.charting.axis2d.Base"]=true;dojo.provide("dojox.charting.axis2d.Base");dojo.declare("dojox.charting.axis2d.Base",dojox.charting.Element,{constructor:function(_273,_274){this.vertical=_274&&_274.vertical;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_279){return this;}});}if(!dojo._hasResource["dojox.lang.utils"]){dojo._hasResource["dojox.lang.utils"]=true;dojo.provide("dojox.lang.utils");(function(){var _27a={},du=dojox.lang.utils;var _27c=function(o){if(dojo.isArray(o)){return dojo._toArray(o);}if(!dojo.isObject(o)||dojo.isFunction(o)){return o;}return dojo.delegate(o);};dojo.mixin(du,{coerceType:function(_27e,_27f){switch(typeof _27e){case "number":return Number(eval("("+_27f+")"));case "string":return String(_27f);case "boolean":return Boolean(eval("("+_27f+")"));}return eval("("+_27f+")");},updateWithObject:function(_280,_281,conv){if(!_281){return _280;}for(var x in _280){if(x in _281&&!(x in _27a)){var t=_280[x];if(t&&typeof t=="object"){du.updateWithObject(t,_281[x],conv);}else{_280[x]=conv?du.coerceType(t,_281[x]):_27c(_281[x]);}}}return _280;},updateWithPattern:function(_285,_286,_287,conv){if(!_286||!_287){return _285;}for(var x in _287){if(x in _286&&!(x in _27a)){_285[x]=conv?du.coerceType(_287[x],_286[x]):_27c(_286[x]);}}return _285;}});})();}if(!dojo._hasResource["dojox.charting.axis2d.Default"]){dojo._hasResource["dojox.charting.axis2d.Default"]=true;dojo.provide("dojox.charting.axis2d.Default");(function(){var dc=dojox.charting,df=dojox.lang.functional,du=dojox.lang.utils,g=dojox.gfx,lin=dc.scaler.linear,_28f=4;dojo.declare("dojox.charting.axis2d.Default",dojox.charting.axis2d.Base,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,htmlLabels:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,stroke:{},majorTick:{},minorTick:{},microTick:{},font:"",fontColor:""},constructor:function(_290,_291){this.opt=dojo.delegate(this.defaultParams,_291);du.updateWithPattern(this.opt,_291,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_292,_293){this.scale=_292;this.offset=_293;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},calculate:function(min,max,span,_297){if(this.initialized()){return this;}this.labels="labels" in this.opt?this.opt.labels:_297;this.scaler=lin.buildScaler(min,max,span,this.opt);if("scale" in this){this.opt.from=this.scaler.bounds.lower+this.offset;this.opt.to=(this.scaler.bounds.upper-this.scaler.bounds.lower)/this.scale+this.opt.from;if(!isFinite(this.opt.from)||isNaN(this.opt.from)||!isFinite(this.opt.to)||isNaN(this.opt.to)||this.opt.to-this.opt.from>=this.scaler.bounds.upper-this.scaler.bounds.lower){delete this.opt.from;delete this.opt.to;delete this.scale;delete this.offset;}else{if(this.opt.from<this.scaler.bounds.lower){this.opt.to+=this.scaler.bounds.lower-this.opt.from;this.opt.from=this.scaler.bounds.lower;}else{if(this.opt.to>this.scaler.bounds.upper){this.opt.from+=this.scaler.bounds.upper-this.opt.to;this.opt.to=this.scaler.bounds.upper;}}this.offset=this.opt.from-this.scaler.bounds.lower;}this.scaler=lin.buildScaler(min,max,span,this.opt);if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}var _298=0,ta=this.chart.theme.axis,_29a="font" in this.opt?this.opt.font:ta.font,size=_29a?g.normalizedLength(g.splitFontString(_29a).size):0;if(this.vertical){if(size){_298=size+_28f;}}else{if(size){var _29c,i;if(this.opt.labelFunc&&this.opt.maxLabelSize){_29c=this.opt.maxLabelSize;}else{if(this.labels){_29c=df.foldl(df.map(this.labels,function(_29e){return dojox.gfx._base._getTextBox(_29e.text,{font:_29a}).w;}),"Math.max(a, b)",0);}else{var _29f=Math.ceil(Math.log(Math.max(Math.abs(this.scaler.bounds.from),Math.abs(this.scaler.bounds.to)))/Math.LN10),t=[];if(this.scaler.bounds.from<0||this.scaler.bounds.to<0){t.push("-");}t.push(dojo.string.rep("9",_29f));var _2a1=Math.floor(Math.log(this.scaler.bounds.to-this.scaler.bounds.from)/Math.LN10);if(_2a1>0){t.push(".");for(i=0;i<_2a1;++i){t.push("9");}}_29c=dojox.gfx._base._getTextBox(t.join(""),{font:_29a}).w;}}_298=_29c+_28f;}}this.scaler.minMinorStep=_298;this.ticks=lin.buildTicks(this.scaler,this.opt);return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;},getOffsets:function(){var _2a2={l:0,r:0,t:0,b:0},_2a3,a,b,c,d,gtb=dojox.gfx._base._getTextBox,gl=dc.scaler.common.getNumericLabel,_2aa=0,ta=this.chart.theme.axis,_2ac="font" in this.opt?this.opt.font:ta.font,_2ad="majorTick" in this.opt?this.opt.majorTick:ta.majorTick,_2ae="minorTick" in this.opt?this.opt.minorTick:ta.minorTick,size=_2ac?g.normalizedLength(g.splitFontString(_2ac).size):0,s=this.scaler;if(!s){return _2a2;}if(this.vertical){if(size){if(this.opt.labelFunc&&this.opt.maxLabelSize){_2a3=this.opt.maxLabelSize;}else{if(this.labels){_2a3=df.foldl(df.map(this.labels,function(_2b1){return dojox.gfx._base._getTextBox(_2b1.text,{font:_2ac}).w;}),"Math.max(a, b)",0);}else{a=gtb(gl(s.major.start,s.major.prec,this.opt),{font:_2ac}).w;b=gtb(gl(s.major.start+s.major.count*s.major.tick,s.major.prec,this.opt),{font:_2ac}).w;c=gtb(gl(s.minor.start,s.minor.prec,this.opt),{font:_2ac}).w;d=gtb(gl(s.minor.start+s.minor.count*s.minor.tick,s.minor.prec,this.opt),{font:_2ac}).w;_2a3=Math.max(a,b,c,d);}}_2aa=_2a3+_28f;}_2aa+=_28f+Math.max(_2ad.length,_2ae.length);_2a2[this.opt.leftBottom?"l":"r"]=_2aa;_2a2.t=_2a2.b=size/2;}else{if(size){_2aa=size+_28f;}_2aa+=_28f+Math.max(_2ad.length,_2ae.length);_2a2[this.opt.leftBottom?"b":"t"]=_2aa;if(size){if(this.opt.labelFunc&&this.opt.maxLabelSize){_2a3=this.opt.maxLabelSize;}else{if(this.labels){_2a3=df.foldl(df.map(this.labels,function(_2b2){return dojox.gfx._base._getTextBox(_2b2.text,{font:_2ac}).w;}),"Math.max(a, b)",0);}else{a=gtb(gl(s.major.start,s.major.prec,this.opt),{font:_2ac}).w;b=gtb(gl(s.major.start+s.major.count*s.major.tick,s.major.prec,this.opt),{font:_2ac}).w;c=gtb(gl(s.minor.start,s.minor.prec,this.opt),{font:_2ac}).w;d=gtb(gl(s.minor.start+s.minor.count*s.minor.tick,s.minor.prec,this.opt),{font:_2ac}).w;_2a3=Math.max(a,b,c,d);}}_2a2.l=_2a2.r=_2a3/2;}}return _2a2;},render:function(dim,_2b4){if(!this.dirty){return this;}var _2b5,stop,_2b7,_2b8,_2b9,_2ba,ta=this.chart.theme.axis,_2bc="stroke" in this.opt?this.opt.stroke:ta.stroke,_2bd="majorTick" in this.opt?this.opt.majorTick:ta.majorTick,_2be="minorTick" in this.opt?this.opt.minorTick:ta.minorTick,_2bf="microTick" in this.opt?this.opt.microTick:ta.minorTick,_2c0="font" in this.opt?this.opt.font:ta.font,_2c1="fontColor" in this.opt?this.opt.fontColor:ta.fontColor,_2c2=Math.max(_2bd.length,_2be.length),size=_2c0?g.normalizedLength(g.splitFontString(_2c0).size):0;if(this.vertical){_2b5={y:dim.height-_2b4.b};stop={y:_2b4.t};_2b7={x:0,y:-1};if(this.opt.leftBottom){_2b5.x=stop.x=_2b4.l;_2b8={x:-1,y:0};_2ba="end";}else{_2b5.x=stop.x=dim.width-_2b4.r;_2b8={x:1,y:0};_2ba="start";}_2b9={x:_2b8.x*(_2c2+_28f),y:size*0.4};}else{_2b5={x:_2b4.l};stop={x:dim.width-_2b4.r};_2b7={x:1,y:0};_2ba="middle";if(this.opt.leftBottom){_2b5.y=stop.y=dim.height-_2b4.b;_2b8={x:0,y:1};_2b9={y:_2c2+_28f+size};}else{_2b5.y=stop.y=_2b4.t;_2b8={x:0,y:-1};_2b9={y:-_2c2-_28f};}_2b9.x=0;}this.cleanGroup();try{var s=this.group,c=this.scaler,t=this.ticks,_2c7,f=lin.getTransformerFromModel(this.scaler),_2c9=dojox.gfx.renderer=="canvas",_2ca=_2c9||this.opt.htmlLabels&&!dojo.isIE&&!dojo.isOpera?"html":"gfx",dx=_2b8.x*_2bd.length,dy=_2b8.y*_2bd.length;s.createLine({x1:_2b5.x,y1:_2b5.y,x2:stop.x,y2:stop.y}).setStroke(_2bc);dojo.forEach(t.major,function(tick){var _2ce=f(tick.value),elem,x=_2b5.x+_2b7.x*_2ce,y=_2b5.y+_2b7.y*_2ce;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_2bd);if(tick.label){elem=dc.axis2d.common.createText[_2ca](this.chart,s,x+_2b9.x,y+_2b9.y,_2ba,tick.label,_2c0,_2c1);if(_2ca=="html"){this.htmlElements.push(elem);}}},this);dx=_2b8.x*_2be.length;dy=_2b8.y*_2be.length;_2c7=c.minMinorStep<=c.minor.tick*c.bounds.scale;dojo.forEach(t.minor,function(tick){var _2d3=f(tick.value),elem,x=_2b5.x+_2b7.x*_2d3,y=_2b5.y+_2b7.y*_2d3;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_2be);if(_2c7&&tick.label){elem=dc.axis2d.common.createText[_2ca](this.chart,s,x+_2b9.x,y+_2b9.y,_2ba,tick.label,_2c0,_2c1);if(_2ca=="html"){this.htmlElements.push(elem);}}},this);dx=_2b8.x*_2bf.length;dy=_2b8.y*_2bf.length;dojo.forEach(t.micro,function(tick){var _2d8=f(tick.value),elem,x=_2b5.x+_2b7.x*_2d8,y=_2b5.y+_2b7.y*_2d8;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_2bf);},this);}catch(e){}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.common"]){dojo._hasResource["dojox.charting.plot2d.common"]=true;dojo.provide("dojox.charting.plot2d.common");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common;dojo.mixin(dojox.charting.plot2d.common,{makeStroke:function(_2de){if(!_2de){return _2de;}if(typeof _2de=="string"||_2de instanceof dojo.Color){_2de={color:_2de};}return dojox.gfx.makeParameters(dojox.gfx.defaultStroke,_2de);},augmentColor:function(_2df,_2e0){var t=new dojo.Color(_2df),c=new dojo.Color(_2e0);c.a=t.a;return c;},augmentStroke:function(_2e3,_2e4){var s=dc.makeStroke(_2e3);if(s){s.color=dc.augmentColor(s.color,_2e4);}return s;},augmentFill:function(fill,_2e7){var fc,c=new dojo.Color(_2e7);if(typeof fill=="string"||fill instanceof dojo.Color){return dc.augmentColor(fill,_2e7);}return fill;},defaultStats:{hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY,vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_2ea){var _2eb=dojo.clone(dc.defaultStats);for(var i=0;i<_2ea.length;++i){var run=_2ea[i];if(!run.data.length){continue;}if(typeof run.data[0]=="number"){var _2ee=_2eb.vmin,_2ef=_2eb.vmax;if(!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,i){var x=i+1,y=val;if(isNaN(y)){y=0;}_2eb.hmin=Math.min(_2eb.hmin,x);_2eb.hmax=Math.max(_2eb.hmax,x);_2eb.vmin=Math.min(_2eb.vmin,y);_2eb.vmax=Math.max(_2eb.vmax,y);});}if("ymin" in run){_2eb.vmin=Math.min(_2ee,run.ymin);}if("ymax" in run){_2eb.vmax=Math.max(_2ef,run.ymax);}}else{var _2f4=_2eb.hmin,_2f5=_2eb.hmax,_2ee=_2eb.vmin,_2ef=_2eb.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){dojo.forEach(run.data,function(val,i){var x=val.x,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_2eb.hmin=Math.min(_2eb.hmin,x);_2eb.hmax=Math.max(_2eb.hmax,x);_2eb.vmin=Math.min(_2eb.vmin,y);_2eb.vmax=Math.max(_2eb.vmax,y);});}if("xmin" in run){_2eb.hmin=Math.min(_2f4,run.xmin);}if("xmax" in run){_2eb.hmax=Math.max(_2f5,run.xmax);}if("ymin" in run){_2eb.vmin=Math.min(_2ee,run.ymin);}if("ymax" in run){_2eb.vmax=Math.max(_2ef,run.ymax);}}}return _2eb;},calculateBarSize:function(_2fa,opt,_2fc){if(!_2fc){_2fc=1;}var gap=opt.gap,size=(_2fa-2*gap)/_2fc;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_2fa-size*_2fc)/2;return {size:size,gap:gap};},collectStackedStats:function(_2ff){var _300=dojo.clone(dc.defaultStats);if(_2ff.length){_300.hmin=Math.min(_300.hmin,1);_300.hmax=df.foldl(_2ff,"seed, run -> Math.max(seed, run.data.length)",_300.hmax);for(var i=0;i<_300.hmax;++i){var v=_2ff[0].data[i];if(isNaN(v)){v=0;}_300.vmin=Math.min(_300.vmin,v);for(var j=1;j<_2ff.length;++j){var t=_2ff[j].data[i];if(isNaN(t)){t=0;}v+=t;}_300.vmax=Math.max(_300.vmax,v);}}return _300;},curve:function(a,_306){var arr=a.slice(0);if(_306=="x"){arr[arr.length]=arr[0];}var p=dojo.map(arr,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_306)){var dx=item.x-arr[i-1].x,dy=arr[i-1].y;return "C"+(item.x-(_306-1)*(dx/_306))+","+dy+" "+(item.x-(dx/_306))+","+item.y+" "+item.x+","+item.y;}else{if(_306=="X"||_306=="x"||_306=="S"){var p0,p1=arr[i-1],p2=arr[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_306=="x"){p0=arr[arr.length-2];}else{p0=p1;}f=1/3;}else{p0=arr[i-2];}if(i==(arr.length-1)){if(_306=="x"){p3=arr[1];}else{p3=p2;}f=1/3;}else{p3=arr[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _319=p0p2*f;var _31a=p1p3*f;if(_319>p1p2/2&&_31a>p1p2/2){_319=p1p2/2;_31a=p1p2/2;}else{if(_319>p1p2/2){_319=p1p2/2;_31a=p1p2/2*p1p3/p0p2;}else{if(_31a>p1p2/2){_31a=p1p2/2;_319=p1p2/2*p0p2/p1p3;}}}if(_306=="S"){if(p0==p1){_319=0;}if(p2==p3){_31a=0;}}bz1x=p1.x+_319*(p2.x-p0.x)/p0p2;bz1y=p1.y+_319*(p2.y-p0.y)/p0p2;bz2x=p2.x-_31a*(p3.x-p1.x)/p1p3;bz2y=p2.y-_31a*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");}});})();}if(!dojo._hasResource["dojox.charting.scaler.primitive"]){dojo._hasResource["dojox.charting.scaler.primitive"]=true;dojo.provide("dojox.charting.scaler.primitive");dojox.charting.scaler.primitive={buildScaler:function(min,max,span,_31e){return {bounds:{lower:min,upper:max,from:min,to:max,scale:span/(max-min),span:span},scaler:dojox.charting.scaler.primitive};},buildTicks:function(_31f,_320){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_321){var _322=_321.bounds.from,_323=_321.bounds.scale;return function(x){return (x-_322)*_323;};},getTransformerFromPlot:function(_325){var _326=_325.bounds.from,_327=_325.bounds.scale;return function(x){return x/_327+_326;};}};}if(!dojo._hasResource["dojox.charting.plot2d.Base"]){dojo._hasResource["dojox.charting.plot2d.Base"]=true;dojo.provide("dojox.charting.plot2d.Base");dojo.declare("dojox.charting.plot2d.Base",dojox.charting.Element,{destroy:function(){this.resetEvents();this.inherited(arguments);},clear:function(){this.series=[];this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){this.series.push(run);return this;},calculateAxes:function(dim){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},render:function(dim,_32d){return this;},getRequiredColors:function(){return this.series.length;},plotEvent:function(o){},connect:function(_32f,_330){this.dirty=true;return dojo.connect(this,"plotEvent",_32f,_330);},events:function(){var ls=this.plotEvent._listeners;if(!ls||!ls.length){return false;}for(var i in ls){if(!(i in Array.prototype)){return true;}}return false;},resetEvents:function(){this.plotEvent({type:"onplotreset",plot:this});},_calc:function(dim,_334){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_334.hmin,_334.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=dojox.charting.scaler.primitive.buildScaler(_334.hmin,_334.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_334.vmin,_334.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=dojox.charting.scaler.primitive.buildScaler(_334.vmin,_334.vmax,dim.height);}},_connectEvents:function(_335,o){_335.connect("onmouseover",this,function(e){o.type="onmouseover";o.event=e;this.plotEvent(o);});_335.connect("onmouseout",this,function(e){o.type="onmouseout";o.event=e;this.plotEvent(o);});_335.connect("onclick",this,function(e){o.type="onclick";o.event=e;this.plotEvent(o);});}});}if(!dojo._hasResource["dojox.charting.plot2d.Default"]){dojo._hasResource["dojox.charting.plot2d.Default"]=true;dojo.provide("dojox.charting.plot2d.Default");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_33d=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Default",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",lines:true,areas:false,markers:false,shadows:0,tension:0},optionalParams:{},constructor:function(_33e,_33f){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_33f);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){this._calc(dim,dc.collectSimpleStats(this.series));return this;},render:function(dim,_342){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_33d);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_346,_347,_348,_349,_34a=this.events();this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;continue;}var s=run.group,_34d,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(typeof run.data[0]=="number"){_34d=dojo.map(run.data,function(v,i){return {x:ht(i+1)+_342.l,y:dim.height-_342.b-vt(v)};},this);}else{_34d=dojo.map(run.data,function(v,i){return {x:ht(v.x)+_342.l,y:dim.height-_342.b-vt(v.y)};},this);}if(!run.fill||!run.stroke){_348=run.dyn.color=new dojo.Color(t.next("color"));}var _354=this.opt.tension?dc.curve(_34d,this.opt.tension):"";if(this.opt.areas){var fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_348);var _356=dojo.clone(_34d);if(this.opt.tension){var _357="L"+_356[_356.length-1].x+","+(dim.height-_342.b)+" L"+_356[0].x+","+(dim.height-_342.b)+" L"+_356[0].x+","+_356[0].y;run.dyn.fill=s.createPath(_354+" "+_357).setFill(fill).getFill();}else{_356.push({x:_34d[_34d.length-1].x,y:dim.height-_342.b});_356.push({x:_34d[0].x,y:dim.height-_342.b});_356.push(_34d[0]);run.dyn.fill=s.createPolyline(_356).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_346=run.stroke?dc.makeStroke(run.stroke):dc.augmentStroke(t.series.stroke,_348);if(run.outline||t.series.outline){_347=dc.makeStroke(run.outline?run.outline:t.series.outline);_347.width=2*_347.width+_346.width;}}if(this.opt.markers){_349=run.dyn.marker=run.marker?run.marker:t.next("marker");}var _358=null,_359=null,_35a=null;if(this.opt.shadows&&_346){var sh=this.opt.shadows,_35c=new dojo.Color([0,0,0,0.3]),_35d=dojo.map(_34d,function(c){return {x:c.x+sh.dx,y:c.y+sh.dy};}),_35f=dojo.clone(_347?_347:_346);_35f.color=_35c;_35f.width+=sh.dw?sh.dw:0;if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_35d,this.opt.tension)).setStroke(_35f).getStroke();}else{run.dyn.shadow=s.createPolyline(_35d).setStroke(_35f).getStroke();}}if(this.opt.markers){_35a=dojo.map(_35d,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_349).setStroke(_35f).setFill(_35c);},this);}}if(this.opt.lines){if(_347){if(this.opt.tension){run.dyn.outline=s.createPath(_354).setStroke(_347).getStroke();}else{run.dyn.outline=s.createPolyline(_34d).setStroke(_347).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_354).setStroke(_346).getStroke();}else{run.dyn.stroke=s.createPolyline(_34d).setStroke(_346).getStroke();}}if(this.opt.markers){_358=new Array(_34d.length);_359=new Array(_34d.length);dojo.forEach(_34d,function(c,i){var path="M"+c.x+" "+c.y+" "+_349;if(_347){_359[i]=s.createPath(path).setStroke(_347);}_358[i]=s.createPath(path).setStroke(_346).setFill(_346.color);},this);if(_34a){dojo.forEach(_358,function(s,i){var o={element:"marker",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:_359[i]||null,shadow:_35a&&_35a[i]||null,cx:_34d[i].x,cy:_34d[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(s,o);},this);}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Lines"]){dojo._hasResource["dojox.charting.plot2d.Lines"]=true;dojo.provide("dojox.charting.plot2d.Lines");dojo.declare("dojox.charting.plot2d.Lines",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Areas"]){dojo._hasResource["dojox.charting.plot2d.Areas"]=true;dojo.provide("dojox.charting.plot2d.Areas");dojo.declare("dojox.charting.plot2d.Areas",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Markers"]){dojo._hasResource["dojox.charting.plot2d.Markers"]=true;dojo.provide("dojox.charting.plot2d.Markers");dojo.declare("dojox.charting.plot2d.Markers",dojox.charting.plot2d.Default,{constructor:function(){this.opt.markers=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]){dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]=true;dojo.provide("dojox.charting.plot2d.MarkersOnly");dojo.declare("dojox.charting.plot2d.MarkersOnly",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Scatter"]){dojo._hasResource["dojox.charting.plot2d.Scatter"]=true;dojo.provide("dojox.charting.plot2d.Scatter");dojo.declare("dojox.charting.plot2d.Scatter",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});}if(!dojo._hasResource["dojox.lang.functional.sequence"]){dojo._hasResource["dojox.lang.functional.sequence"]=true;dojo.provide("dojox.lang.functional.sequence");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{repeat:function(n,f,z,o){o=o||d.global;f=df.lambda(f);var t=new Array(n),i=1;t[0]=z;for(;i<n;t[i]=z=f.call(o,z),++i){}return t;},until:function(pr,f,z,o){o=o||d.global;f=df.lambda(f);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(z),z=f.call(o,z)){}return t;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Stacked"]){dojo._hasResource["dojox.charting.plot2d.Stacked"]=true;dojo.provide("dojox.charting.plot2d.Stacked");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_376=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Stacked",dojox.charting.plot2d.Default,{calculateAxes:function(dim){var _378=dc.collectStackedStats(this.series);this._maxRunLength=_378.hmax;this._calc(dim,_378);return this;},render:function(dim,_37a){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]+=v;}}this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_376);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_383,_384,_385,_386,_387=this.events(),ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group,_38a=dojo.map(acc,function(v,i){return {x:ht(i+1)+_37a.l,y:dim.height-_37a.b-vt(v)};},this);if(!run.fill||!run.stroke){_385=new dojo.Color(t.next("color"));}var _38d=this.opt.tension?dc.curve(_38a,this.opt.tension):"";if(this.opt.areas){var _38e=dojo.clone(_38a);var fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_385);if(this.opt.tension){var p=dc.curve(_38e,this.opt.tension);p+=" L"+_38a[_38a.length-1].x+","+(dim.height-_37a.b)+" L"+_38a[0].x+","+(dim.height-_37a.b)+" L"+_38a[0].x+","+_38a[0].y;run.dyn.fill=s.createPath(p).setFill(fill).getFill();}else{_38e.push({x:_38a[_38a.length-1].x,y:dim.height-_37a.b});_38e.push({x:_38a[0].x,y:dim.height-_37a.b});_38e.push(_38a[0]);run.dyn.fill=s.createPolyline(_38e).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_383=run.stroke?dc.makeStroke(run.stroke):dc.augmentStroke(t.series.stroke,_385);if(run.outline||t.series.outline){_384=dc.makeStroke(run.outline?run.outline:t.series.outline);_384.width=2*_384.width+_383.width;}}if(this.opt.markers){_386=run.dyn.marker=run.marker?run.marker:t.next("marker");}var _391,_392,_393;if(this.opt.shadows&&_383){var sh=this.opt.shadows,_395=new dojo.Color([0,0,0,0.3]),_396=dojo.map(_38a,function(c){return {x:c.x+sh.dx,y:c.y+sh.dy};}),_398=dojo.clone(_384?_384:_383);_398.color=_395;_398.width+=sh.dw?sh.dw:0;if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_396,this.opt.tension)).setStroke(_398).getStroke();}else{run.dyn.shadow=s.createPolyline(_396).setStroke(_398).getStroke();}}if(this.opt.markers){_393=dojo.map(_396,function(c){return s.createPath("M"+c.x+" "+c.y+" "+_386).setStroke(_398).setFill(_395);},this);}}if(this.opt.lines){if(_384){if(this.opt.tension){run.dyn.outline=s.createPath(_38d).setStroke(_384).getStroke();}else{run.dyn.outline=s.createPolyline(_38a).setStroke(_384).getStroke();}}if(this.opt.tension){run.dyn.stroke=s.createPath(_38d).setStroke(_383).getStroke();}else{run.dyn.stroke=s.createPolyline(_38a).setStroke(_383).getStroke();}}if(this.opt.markers){_391=new Array(_38a.length);_392=new Array(_38a.length);dojo.forEach(_38a,function(c,i){var path="M"+c.x+" "+c.y+" "+_386;if(_384){_392[i]=s.createPath(path).setStroke(_384);}_391[i]=s.createPath(path).setStroke(_383).setFill(_383.color);},this);if(_387){dojo.forEach(_391,function(s,i){var o={element:"marker",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:_392[i]||null,shadow:_393&&_393[i]||null,cx:_38a[i].x,cy:_38a[i].y,x:i+1,y:run.data[i]};this._connectEvents(s,o);},this);}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]-=v;}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedLines"]){dojo._hasResource["dojox.charting.plot2d.StackedLines"]=true;dojo.provide("dojox.charting.plot2d.StackedLines");dojo.declare("dojox.charting.plot2d.StackedLines",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.StackedAreas"]){dojo._hasResource["dojox.charting.plot2d.StackedAreas"]=true;dojo.provide("dojox.charting.plot2d.StackedAreas");dojo.declare("dojox.charting.plot2d.StackedAreas",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}if(!dojo._hasResource["dojox.charting.plot2d.Columns"]){dojo._hasResource["dojox.charting.plot2d.Columns"]=true;dojo.provide("dojox.charting.plot2d.Columns");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_3a3=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Columns",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,shadows:null},optionalParams:{minBarSize:1,maxBarSize:1},constructor:function(_3a4,_3a5){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_3a5);du.updateWithPattern(this.opt,_3a5,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){var _3a7=dc.collectSimpleStats(this.series);_3a7.hmin-=0.5;_3a7.hmax+=0.5;this._calc(dim,_3a7);return this;},render:function(dim,_3a9){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_3a3);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_3ad,_3ae,fill,f,gap,_3b2,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3b5=Math.max(0,this._vScaler.bounds.lower),_3b6=vt(_3b5),_3b7=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_3b2=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_3ad=run.dyn.color=new dojo.Color(t.next("color"));}_3ae=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_3ad);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_3ad);for(var j=0;j<run.data.length;++j){var v=run.data[j],vv=vt(v),_3bd=vv-_3b6,h=Math.abs(_3bd);if(_3b2>=1&&h>=1){var rect={x:_3a9.l+ht(j+0.5)+gap,y:dim.height-_3a9.b-(v>_3b5?vv:_3b6),width:_3b2,height:h},_3c0=s.createRect(rect).setFill(fill).setStroke(_3ae);run.dyn.fill=_3c0.getFill();run.dyn.stroke=_3c0.getStroke();if(_3b7){var o={element:"column",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_3c0,x:j+0.5,y:v};this._connectEvents(_3c0,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedColumns"]){dojo._hasResource["dojox.charting.plot2d.StackedColumns"]=true;dojo.provide("dojox.charting.plot2d.StackedColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_3c4=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedColumns",dojox.charting.plot2d.Columns,{calculateAxes:function(dim){var _3c6=dc.collectStackedStats(this.series);this._maxRunLength=_3c6.hmax;_3c6.hmin-=0.5;_3c6.hmax+=0.5;this._calc(dim,_3c6);return this;},render:function(dim,_3c8){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]+=v;}}this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_3c4);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_3d1,_3d2,fill,f,gap,_3d6,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3d9=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_3d6=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_3d1=run.dyn.color=new dojo.Color(t.next("color"));}_3d2=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_3d1);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_3d1);for(var j=0;j<acc.length;++j){var v=acc[j],_3da=vt(v);if(_3d6>=1&&_3da>=1){var _3db=s.createRect({x:_3c8.l+ht(j+0.5)+gap,y:dim.height-_3c8.b-vt(v),width:_3d6,height:_3da}).setFill(fill).setStroke(_3d2);run.dyn.fill=_3db.getFill();run.dyn.stroke=_3db.getStroke();if(_3d9){var o={element:"column",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_3db,x:j+0.5,y:v};this._connectEvents(_3db,o);}}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]-=v;}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]){dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]=true;dojo.provide("dojox.charting.plot2d.ClusteredColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_3df=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredColumns",dojox.charting.plot2d.Columns,{render:function(dim,_3e1){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_3df);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_3e5,_3e6,fill,f,gap,_3ea,_3eb,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3ee=Math.max(0,this._vScaler.bounds.lower),_3ef=vt(_3ee),_3f0=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_3ea=_3eb=f.size;this.resetEvents();for(var i=0;i<this.series.length;++i){var run=this.series[i],_3f3=_3eb*i;if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_3e5=run.dyn.color=new dojo.Color(t.next("color"));}_3e6=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_3e5);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_3e5);for(var j=0;j<run.data.length;++j){var v=run.data[j],vv=vt(v),_3f7=vv-_3ef,h=Math.abs(_3f7);if(_3ea>=1&&h>=1){var _3f9=s.createRect({x:_3e1.l+ht(j+0.5)+gap+_3f3,y:dim.height-_3e1.b-(v>_3ee?vv:_3ef),width:_3ea,height:h}).setFill(fill).setStroke(_3e6);run.dyn.fill=_3f9.getFill();run.dyn.stroke=_3f9.getStroke();if(_3f0){var o={element:"column",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_3f9,x:j+0.5,y:v};this._connectEvents(_3f9,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Bars"]){dojo._hasResource["dojox.charting.plot2d.Bars"]=true;dojo.provide("dojox.charting.plot2d.Bars");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_3fe=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bars",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,shadows:null},optionalParams:{minBarSize:1,maxBarSize:1},constructor:function(_3ff,_400){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_400);du.updateWithPattern(this.opt,_400,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){var _402=dc.collectSimpleStats(this.series),t;_402.hmin-=0.5;_402.hmax+=0.5;t=_402.hmin,_402.hmin=_402.vmin,_402.vmin=t;t=_402.hmax,_402.hmax=_402.vmax,_402.vmax=t;this._calc(dim,_402);return this;},render:function(dim,_405){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_3fe);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_409,_40a,fill,f,gap,_40e,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_411=Math.max(0,this._hScaler.bounds.lower),_412=ht(_411),_413=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_40e=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_409=run.dyn.color=new dojo.Color(t.next("color"));}_40a=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_409);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_409);for(var j=0;j<run.data.length;++j){var v=run.data[j],hv=ht(v),_419=hv-_412,w=Math.abs(_419);if(w>=1&&_40e>=1){var _41b=s.createRect({x:_405.l+(v<_411?hv:_412),y:dim.height-_405.b-vt(j+1.5)+gap,width:w,height:_40e}).setFill(fill).setStroke(_40a);run.dyn.fill=_41b.getFill();run.dyn.stroke=_41b.getStroke();if(_413){var o={element:"bar",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_41b,x:v,y:j+1.5};this._connectEvents(_41b,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.StackedBars"]){dojo._hasResource["dojox.charting.plot2d.StackedBars"]=true;dojo.provide("dojox.charting.plot2d.StackedBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_41f=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedBars",dojox.charting.plot2d.Bars,{calculateAxes:function(dim){var _421=dc.collectStackedStats(this.series),t;this._maxRunLength=_421.hmax;_421.hmin-=0.5;_421.hmax+=0.5;t=_421.hmin,_421.hmin=_421.vmin,_421.vmin=t;t=_421.hmax,_421.hmax=_421.vmax,_421.vmax=t;this._calc(dim,_421);return this;},render:function(dim,_424){if(this._maxRunLength<=0){return this;}var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]+=v;}}this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_41f);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_42d,_42e,fill,f,gap,_432,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_435=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;_432=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_42d=run.dyn.color=new dojo.Color(t.next("color"));}_42e=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_42d);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_42d);for(var j=0;j<acc.length;++j){var v=acc[j],_436=ht(v);if(_436>=1&&_432>=1){var _437=s.createRect({x:_424.l,y:dim.height-_424.b-vt(j+1.5)+gap,width:_436,height:_432}).setFill(fill).setStroke(_42e);run.dyn.fill=_437.getFill();run.dyn.stroke=_437.getStroke();if(_435){var o={element:"bar",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_437,x:v,y:j+1.5};this._connectEvents(_437,o);}}}run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(isNaN(v)){v=0;}acc[j]-=v;}}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]){dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]=true;dojo.provide("dojox.charting.plot2d.ClusteredBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,_43b=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredBars",dojox.charting.plot2d.Bars,{render:function(dim,_43d){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_43b);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_441,_442,fill,f,gap,_446,_447,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_44a=Math.max(0,this._hScaler.bounds.lower),_44b=ht(_44a),_44c=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;_446=_447=f.size;this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i],_44f=_447*(this.series.length-i-1);if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){_441=run.dyn.color=new dojo.Color(t.next("color"));}_442=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,_441);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,_441);for(var j=0;j<run.data.length;++j){var v=run.data[j],hv=ht(v),_453=hv-_44b,w=Math.abs(_453);if(w>=1&&_446>=1){var _455=s.createRect({x:_43d.l+(v<_44a?hv:_44b),y:dim.height-_43d.b-vt(j+1.5)+gap+_44f,width:w,height:_446}).setFill(fill).setStroke(_442);run.dyn.fill=_455.getFill();run.dyn.stroke=_455.getStroke();if(_44c){var o={element:"bar",index:j,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:_455,x:v,y:j+1.5};this._connectEvents(_455,o);}}}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Grid"]){dojo._hasResource["dojox.charting.plot2d.Grid"]=true;dojo.provide("dojox.charting.plot2d.Grid");(function(){var du=dojox.lang.utils;dojo.declare("dojox.charting.plot2d.Grid",dojox.charting.Element,{defaultParams:{hAxis:"x",vAxis:"y",hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:"none",vStripes:"none"},optionalParams:{},constructor:function(_458,_459){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_459);this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.dirty=true;},clear:function(){this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},addSeries:function(run){return this;},calculateAxes:function(dim){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},getRequiredColors:function(){return 0;},render:function(dim,_45e){this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.group,ta=this.chart.theme.axis;try{var _461=this._vAxis.getScaler(),vt=_461.scaler.getTransformerFromModel(_461),_463=this._vAxis.getTicks();if(this.opt.hMinorLines){dojo.forEach(_463.minor,function(tick){var y=dim.height-_45e.b-vt(tick.value);s.createLine({x1:_45e.l,y1:y,x2:dim.width-_45e.r,y2:y}).setStroke(ta.minorTick);});}if(this.opt.hMajorLines){dojo.forEach(_463.major,function(tick){var y=dim.height-_45e.b-vt(tick.value);s.createLine({x1:_45e.l,y1:y,x2:dim.width-_45e.r,y2:y}).setStroke(ta.majorTick);});}}catch(e){}try{var _468=this._hAxis.getScaler(),ht=_468.scaler.getTransformerFromModel(_468),_463=this._hAxis.getTicks();if(_463&&this.opt.vMinorLines){dojo.forEach(_463.minor,function(tick){var x=_45e.l+ht(tick.value);s.createLine({x1:x,y1:_45e.t,x2:x,y2:dim.height-_45e.b}).setStroke(ta.minorTick);});}if(_463&&this.opt.vMajorLines){dojo.forEach(_463.major,function(tick){var x=_45e.l+ht(tick.value);s.createLine({x1:x,y1:_45e.t,x2:x,y2:dim.height-_45e.b}).setStroke(ta.majorTick);});}}catch(e){}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Pie"]){dojo._hasResource["dojox.charting.plot2d.Pie"]=true;dojo.provide("dojox.charting.plot2d.Pie");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,da=dojox.charting.axis2d.common,g=dojox.gfx;dojo.declare("dojox.charting.plot2d.Pie",dojox.charting.Element,{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true},optionalParams:{font:"",fontColor:"",radius:0},constructor:function(_473,_474){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_474);du.updateWithPattern(this.opt,_474,this.optionalParams);this.run=null;this.dyn=[];},destroy:function(){this.resetEvents();this.inherited(arguments);},clear:function(){this.dirty=true;this.dyn=[];this.run=null;return this;},setAxis:function(axis){return this;},addSeries:function(run){this.run=run;return this;},calculateAxes:function(dim){return this;},getRequiredColors:function(){return this.run?this.run.data.length:0;},plotEvent:function(o){},connect:function(_479,_47a){this.dirty=true;return dojo.connect(this,"plotEvent",_479,_47a);},events:function(){var ls=this.plotEvent._listeners;if(!ls||!ls.length){return false;}for(var i in ls){if(!(i in Array.prototype)){return true;}}return false;},resetEvents:function(){this.plotEvent({type:"onplotreset",plot:this});},_connectEvents:function(_47d,o){_47d.connect("onmouseover",this,function(e){o.type="onmouseover";o.event=e;this.plotEvent(o);});_47d.connect("onmouseout",this,function(e){o.type="onmouseout";o.event=e;this.plotEvent(o);});_47d.connect("onclick",this,function(e){o.type="onclick";o.event=e;this.plotEvent(o);});},render:function(dim,_483){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,_485,t=this.chart.theme;this.resetEvents();if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_483.l-_483.r)/2,ry=(dim.height-_483.t-_483.b)/2,r=Math.min(rx,ry),_48a="font" in this.opt?this.opt.font:t.axis.font,size=_48a?g.normalizedLength(g.splitFontString(_48a).size):0,_48c="fontColor" in this.opt?this.opt.fontColor:t.axis.fontColor,_48d=0,step,_48f,_490,_491,_492,_493,run=this.run.data,_495=this.events();if(typeof run[0]=="number"){_48f=df.map(run,"Math.max(x, 0)");if(df.every(_48f,"<= 0")){return this;}_490=df.map(_48f,"/this",df.foldl(_48f,"+",0));if(this.opt.labels){_491=dojo.map(_490,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_48f=df.map(run,"Math.max(x.y, 0)");if(df.every(_48f,"<= 0")){return this;}_490=df.map(_48f,"/this",df.foldl(_48f,"+",0));if(this.opt.labels){_491=dojo.map(_490,function(x,i){if(x<=0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}if(this.opt.labels){_492=df.foldl1(df.map(_491,function(_49a){return dojox.gfx._base._getTextBox(_49a,{font:_48a}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_492,ry-size)+this.opt.labelOffset;}_493=r-this.opt.labelOffset;}if("radius" in this.opt){r=this.opt.radius;_493=r-this.opt.labelOffset;}var _49b={cx:_483.l+rx,cy:_483.t+ry,r:r};this.dyn=[];dojo.some(_490,function(_49c,i){if(_49c<=0){return false;}var v=run[i];if(_49c>=1){var _49f,fill,_4a1;if(typeof v=="object"){_49f="color" in v?v.color:new dojo.Color(t.next("color"));fill="fill" in v?v.fill:dc.augmentFill(t.series.fill,_49f);_4a1="stroke" in v?v.stroke:dc.augmentStroke(t.series.stroke,_49f);}else{_49f=new dojo.Color(t.next("color"));fill=dc.augmentFill(t.series.fill,_49f);_4a1=dc.augmentStroke(t.series.stroke,_49f);}var _4a2=s.createCircle(_49b).setFill(fill).setStroke(_4a1);this.dyn.push({color:_49f,fill:fill,stroke:_4a1});if(_495){var o={element:"slice",index:i,run:this.run,plot:this,shape:_4a2,x:i,y:typeof v=="number"?v:v.y,cx:_49b.cx,cy:_49b.cy,cr:r};this._connectEvents(_4a2,o);}return true;}var end=_48d+_49c*2*Math.PI;if(i+1==_490.length){end=2*Math.PI;}var step=end-_48d,x1=_49b.cx+r*Math.cos(_48d),y1=_49b.cy+r*Math.sin(_48d),x2=_49b.cx+r*Math.cos(end),y2=_49b.cy+r*Math.sin(end);var _49f,fill,_4a1;if(typeof v=="object"){_49f="color" in v?v.color:new dojo.Color(t.next("color"));fill="fill" in v?v.fill:dc.augmentFill(t.series.fill,_49f);_4a1="stroke" in v?v.stroke:dc.augmentStroke(t.series.stroke,_49f);}else{_49f=new dojo.Color(t.next("color"));fill=dc.augmentFill(t.series.fill,_49f);_4a1=dc.augmentStroke(t.series.stroke,_49f);}var _4a2=s.createPath({}).moveTo(_49b.cx,_49b.cy).lineTo(x1,y1).arcTo(r,r,0,step>Math.PI,true,x2,y2).lineTo(_49b.cx,_49b.cy).closePath().setFill(fill).setStroke(_4a1);this.dyn.push({color:_49f,fill:fill,stroke:_4a1});if(_495){var o={element:"slice",index:i,run:this.run,plot:this,shape:_4a2,x:i,y:typeof v=="number"?v:v.y,cx:_49b.cx,cy:_49b.cy,cr:r};this._connectEvents(_4a2,o);}_48d=end;return false;},this);if(this.opt.labels){_48d=0;dojo.some(_490,function(_4aa,i){if(_4aa<=0){return false;}if(_4aa>=1){var v=run[i],elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"](this.chart,s,_49b.cx,_49b.cy+size/2,"middle",_491[i],_48a,(typeof v=="object"&&"fontColor" in v)?v.fontColor:_48c);if(this.opt.htmlLabels){this.htmlElements.push(elem);}return true;}var end=_48d+_4aa*2*Math.PI,v=run[i];if(i+1==_490.length){end=2*Math.PI;}var _4af=(_48d+end)/2,x=_49b.cx+_493*Math.cos(_4af),y=_49b.cy+_493*Math.sin(_4af)+size/2;var elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"](this.chart,s,x,y,"middle",_491[i],_48a,(typeof v=="object"&&"fontColor" in v)?v.fontColor:_48c);if(this.opt.htmlLabels){this.htmlElements.push(elem);}_48d=end;return false;},this);}return this;},_getLabel:function(_4b2){return this.opt.fixed?_4b2.toFixed(this.opt.precision):_4b2.toString();}});})();}if(!dojo._hasResource["dojox.charting.plot2d.Bubble"]){dojo._hasResource["dojox.charting.plot2d.Bubble"]=true;dojo.provide("dojox.charting.plot2d.Bubble");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,_4b6=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bubble",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y"},optionalParams:{},constructor:function(_4b7,_4b8){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,_4b8);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;},calculateAxes:function(dim){this._calc(dim,dc.collectSimpleStats(this.series));return this;},render:function(dim,_4bb){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,_4b6);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_4bf,_4c0,_4c1,_4c2,_4c3,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_4c6=this.events();this.resetEvents();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}var s=run.group,_4c9=dojo.map(run.data,function(v,i){return {x:ht(v.x)+_4bb.l,y:dim.height-_4bb.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)};},this);if(run.fill){_4c1=run.fill;}else{if(run.stroke){_4c1=run.stroke;}else{_4c1=run.dyn.color=new dojo.Color(t.next("color"));}}run.dyn.fill=_4c1;_4bf=run.dyn.stroke=run.stroke?dc.makeStroke(run.stroke):dc.augmentStroke(t.series.stroke,_4c1);var _4cc=null,_4cd=null,_4ce=null;if(this.opt.shadows&&_4bf){var sh=this.opt.shadows,_4c3=new dojo.Color([0,0,0,0.2]),_4c2=dojo.clone(_4c0?_4c0:_4bf);_4c2.color=_4c3;_4c2.width+=sh.dw?sh.dw:0;run.dyn.shadow=_4c2;var _4d0=dojo.map(_4c9,function(item){var sh=this.opt.shadows;return s.createCircle({cx:item.x+sh.dx,cy:item.y+sh.dy,r:item.radius}).setStroke(_4c2).setFill(_4c3);},this);}if(run.outline||t.series.outline){_4c0=dc.makeStroke(run.outline?run.outline:t.series.outline);_4c0.width=2*_4c0.width+_4bf.width;run.dyn.outline=_4c0;_4cd=dojo.map(_4c9,function(item){s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_4c0);},this);}_4cc=dojo.map(_4c9,function(item){return s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_4bf).setFill(_4c1);},this);if(_4c6){dojo.forEach(_4cc,function(s,i){var o={element:"circle",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:_4cd&&_4cd[i]||null,shadow:_4ce&&_4ce[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_4c9[i].x,cy:_4c9[i].y,cr:_4c9[i].radius};this._connectEvents(s,o);},this);}run.dirty=false;}this.dirty=false;return this;}});})();}if(!dojo._hasResource["dojox.charting.Chart2D"]){dojo._hasResource["dojox.charting.Chart2D"]=true;dojo.provide("dojox.charting.Chart2D");(function(){var df=dojox.lang.functional,dc=dojox.charting,_4da=df.lambda("item.clear()"),_4db=df.lambda("item.purgeGroup()"),_4dc=df.lambda("item.destroy()"),_4dd=df.lambda("item.dirty = false"),_4de=df.lambda("item.dirty = true");dojo.declare("dojox.charting.Chart2D",null,{constructor:function(node,_4e0){if(!_4e0){_4e0={};}this.margins=_4e0.margins?_4e0.margins:{l:10,t:10,r:10,b:10};this.stroke=_4e0.stroke;this.fill=_4e0.fill;this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.coords=null;this.node=dojo.byId(node);var box=dojo.marginBox(node);this.surface=dojox.gfx.createSurface(this.node,box.w,box.h);},destroy:function(){dojo.forEach(this.series,_4dc);dojo.forEach(this.stack,_4dc);df.forIn(this.axes,_4dc);this.surface.destroy();},getCoords:function(){if(!this.coords){this.coords=dojo.coords(this.node,true);}return this.coords;},setTheme:function(_4e2){this.theme=_4e2._clone();this.dirty=true;return this;},addAxis:function(name,_4e4){var axis;if(!_4e4||!("type" in _4e4)){axis=new dc.axis2d.Default(this,_4e4);}else{axis=typeof _4e4.type=="string"?new dc.axis2d[_4e4.type](this,_4e4):new _4e4.type(this,_4e4);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_4e9){var plot;if(!_4e9||!("type" in _4e9)){plot=new dc.plot2d.Default(this,_4e9);}else{plot=typeof _4e9.type=="string"?new dc.plot2d[_4e9.type](this,_4e9):new _4e9.type(this,_4e9);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},removePlot:function(name){if(name in this.plots){var _4ec=this.plots[name];delete this.plots[name];this.stack[_4ec].destroy();this.stack.splice(_4ec,1);df.forIn(this.plots,function(idx,name,_4ef){if(idx>_4ec){_4ef[name]=idx-1;}});this.dirty=true;}return this;},addSeries:function(name,data,_4f2){var run=new dc.Series(this,data,_4f2);if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}run.name=name;this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},removeSeries:function(name){if(name in this.runs){var _4f5=this.runs[name],_4f6=this.series[_4f5].plot;delete this.runs[name];this.series[_4f5].destroy();this.series.splice(_4f5,1);df.forIn(this.runs,function(idx,name,runs){if(idx>_4f5){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data){if(name in this.runs){var run=this.series[this.runs[name]];run.data=data;run.dirty=true;this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}return this;},resize:function(_4fd,_4fe){var box;switch(arguments.length){case 0:box=dojo.marginBox(this.node);break;case 1:box=_4fd;break;default:box={w:_4fd,h:_4fe};break;}dojo.marginBox(this.node,box);this.surface.setDimensions(box.w,box.h);this.dirty=true;this.coords=null;return this.render();},getGeometry:function(){var ret={};df.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_503,_504){var axis=this.axes[name];if(axis){axis.setWindow(_503,_504);}return this;},setWindow:function(sx,sy,dx,dy){if(!("plotArea" in this)){this.calculateGeometry();}df.forIn(this.axes,function(axis){var _50b,_50c,_50d=axis.getScaler().bounds,s=_50d.span/(_50d.upper-_50d.lower);if(axis.vertical){_50b=sy;_50c=dy/s/_50b;}else{_50b=sx;_50c=dx/s/_50b;}axis.setWindow(_50b,_50c);});return this;},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}dojo.forEach(this.stack,function(plot){if(plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty)){plot.calculateAxes(this.plotArea);}},this);return this;},fullGeometry:function(){this._makeDirty();dojo.forEach(this.stack,_4da);if(!this.theme){this.setTheme(new dojox.charting.Theme(dojox.charting._def));}dojo.forEach(this.series,function(run){if(!(run.plot in this.plots)){var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);dojo.forEach(this.stack,function(plot){if(plot.hAxis){plot.setAxis(this.axes[plot.hAxis]);}if(plot.vAxis){plot.setAxis(this.axes[plot.vAxis]);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=dojox.gfx.normalizedLength(dim.width);dim.height=dojox.gfx.normalizedLength(dim.height);df.forIn(this.axes,_4da);dojo.forEach(this.stack,function(plot){plot.calculateAxes(dim);});var _515=this.offsets={l:0,r:0,t:0,b:0};df.forIn(this.axes,function(axis){df.forIn(axis.getOffsets(),function(o,i){_515[i]+=o;});});df.forIn(this.margins,function(o,i){_515[i]+=o;});this.plotArea={width:dim.width-_515.l-_515.r,height:dim.height-_515.t-_515.b};df.forIn(this.axes,_4da);dojo.forEach(this.stack,function(plot){plot.calculateAxes(this.plotArea);},this);return this;},render:function(){if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();df.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);df.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();if(this.surface.render){this.surface.render();}return this;},fullRender:function(){this.fullGeometry();var _51e=this.offsets,dim=this.dim;var _520=df.foldl(this.stack,"z + plot.getRequiredColors()",0);this.theme.defineColors({num:_520,cache:false});dojo.forEach(this.series,_4db);df.forIn(this.axes,_4db);dojo.forEach(this.stack,_4db);this.surface.clear();var t=this.theme,fill=t.plotarea&&t.plotarea.fill,_523=t.plotarea&&t.plotarea.stroke;if(fill){this.surface.createRect({x:_51e.l,y:_51e.t,width:dim.width-_51e.l-_51e.r,height:dim.height-_51e.t-_51e.b}).setFill(fill);}if(_523){this.surface.createRect({x:_51e.l,y:_51e.t,width:dim.width-_51e.l-_51e.r-1,height:dim.height-_51e.t-_51e.b-1}).setStroke(_523);}df.foldr(this.stack,function(z,plot){return plot.render(dim,_51e),0;},0);fill=this.fill?this.fill:(t.chart&&t.chart.fill);_523=this.stroke?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node,fill=new dojo.Color(dojo.style(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new dojo.Color(dojo.style(node,"backgroundColor"));node=node.parentNode;}}if(fill){if(_51e.l){this.surface.createRect({width:_51e.l,height:dim.height+1}).setFill(fill);}if(_51e.r){this.surface.createRect({x:dim.width-_51e.r,width:_51e.r+1,height:dim.height+1}).setFill(fill);}if(_51e.t){this.surface.createRect({width:dim.width+1,height:_51e.t}).setFill(fill);}if(_51e.b){this.surface.createRect({y:dim.height-_51e.b,width:dim.width+1,height:_51e.b+2}).setFill(fill);}}if(_523){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_523);}df.forIn(this.axes,function(axis){axis.render(dim,_51e);});this._makeClean();if(this.surface.render){this.surface.render();}return this;},connectToPlot:function(name,_529,_52a){return name in this.plots?this.stack[this.plots[name]].connect(_529,_52a):null;},_makeClean:function(){dojo.forEach(this.axes,_4dd);dojo.forEach(this.stack,_4dd);dojo.forEach(this.series,_4dd);this.dirty=false;},_makeDirty:function(){dojo.forEach(this.axes,_4de);dojo.forEach(this.stack,_4de);dojo.forEach(this.series,_4de);this.dirty=true;},_invalidateDependentPlots:function(_52b,_52c){if(_52b in this.plots){var plot=this.stack[this.plots[_52b]],axis,_52f=_52c?"vAxis":"hAxis";if(plot[_52f]){axis=this.axes[plot[_52f]];if(axis.dependOnData()){axis.dirty=true;dojo.forEach(this.stack,function(p){if(p[_52f]&&p[_52f]==plot[_52f]){p.dirty=true;}});}}else{plot.dirty=true;}}}});})();}if(!dojo._hasResource["dojo.fx.easing"]){dojo._hasResource["dojo.fx.easing"]=true;dojo.provide("dojo.fx.easing");dojo.fx.easing={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-dojo.fx.easing.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return dojo.fx.easing.bounceIn(n*2)/2;}return (dojo.fx.easing.bounceOut(n*2-1)/2)+0.5;}};}if(!dojo._hasResource["dojox.gfx.fx"]){dojo._hasResource["dojox.gfx.fx"]=true;dojo.provide("dojox.gfx.fx");(function(){var d=dojo,g=dojox.gfx,m=g.matrix;var _55f=function(_560,end){this.start=_560,this.end=end;};d.extend(_55f,{getValue:function(r){return (this.end-this.start)*r+this.start;}});var _563=function(_564,end,unit){this.start=_564,this.end=end;this.unit=unit;};d.extend(_563,{getValue:function(r){return (this.end-this.start)*r+this.start+this.unit;}});var _568=function(_569,end){this.start=_569,this.end=end;this.temp=new dojo.Color();};d.extend(_568,{getValue:function(r){return d.blendColors(this.start,this.end,r,this.temp);}});var _56c=function(_56d){this.values=_56d;this.length=_56d.length;};d.extend(_56c,{getValue:function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];}});var _56f=function(_570,def){this.values=_570;this.def=def?def:{};};d.extend(_56f,{getValue:function(r){var ret=dojo.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;}});var _575=function(_576,_577){this.stack=_576;this.original=_577;};d.extend(_575,{getValue:function(r){var ret=[];dojo.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=dojo.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_57f=f.apply(m,val);if(_57f instanceof m.Matrix2D){ret.push(_57f);}},this);return ret;}});var _580=new d.Color(0,0,0,0);var _581=function(prop,obj,name,def){if(prop.values){return new _56c(prop.values);}var _586,_587,end;if(prop.start){_587=g.normalizeColor(prop.start);}else{_587=_586=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_586){_586=obj?(name?obj[name]:obj):def;}end=_586;}return new _568(_587,end);};var _589=function(prop,obj,name,def){if(prop.values){return new _56c(prop.values);}var _58e,_58f,end;if(prop.start){_58f=prop.start;}else{_58f=_58e=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _58e!="number"){_58e=obj?obj[name]:def;}end=_58e;}return new _55f(_58f,end);};g.fx.animateStroke=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d._Animation(args),_593=args.shape,_594;d.connect(anim,"beforeBegin",anim,function(){_594=_593.getStroke();var prop=args.color,_596={},_597,_598,end;if(prop){_596.color=_581(prop,_594,"color",_580);}prop=args.style;if(prop&&prop.values){_596.style=new _56c(prop.values);}prop=args.width;if(prop){_596.width=_589(prop,_594,"width",1);}prop=args.cap;if(prop&&prop.values){_596.cap=new _56c(prop.values);}prop=args.join;if(prop){if(prop.values){_596.join=new _56c(prop.values);}else{_598=prop.start?prop.start:(_594&&_594.join||0);end=prop.end?prop.end:(_594&&_594.join||0);if(typeof _598=="number"&&typeof end=="number"){_596.join=new _55f(_598,end);}}}this.curve=new _56f(_596,_594);});d.connect(anim,"onAnimate",_593,"setStroke");return anim;};g.fx.animateFill=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d._Animation(args),_59c=args.shape,fill;d.connect(anim,"beforeBegin",anim,function(){fill=_59c.getFill();var prop=args.color,_59f={};if(prop){this.curve=_581(prop,fill,"",_580);}});d.connect(anim,"onAnimate",_59c,"setFill");return anim;};g.fx.animateFont=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d._Animation(args),_5a2=args.shape,font;d.connect(anim,"beforeBegin",anim,function(){font=_5a2.getFont();var prop=args.style,_5a5={},_5a6,_5a7,end;if(prop&&prop.values){_5a5.style=new _56c(prop.values);}prop=args.variant;if(prop&&prop.values){_5a5.variant=new _56c(prop.values);}prop=args.weight;if(prop&&prop.values){_5a5.weight=new _56c(prop.values);}prop=args.family;if(prop&&prop.values){_5a5.family=new _56c(prop.values);}prop=args.size;if(prop&&prop.unit){_5a7=parseFloat(prop.start?prop.start:(_5a2.font&&_5a2.font.size||"0"));end=parseFloat(prop.end?prop.end:(_5a2.font&&_5a2.font.size||"0"));_5a5.size=new _563(_5a7,end,prop.unit);}this.curve=new _56f(_5a5,font);});d.connect(anim,"onAnimate",_5a2,"setFont");return anim;};g.fx.animateTransform=function(args){if(!args.easing){args.easing=d._defaultEasing;}var anim=new d._Animation(args),_5ab=args.shape,_5ac;d.connect(anim,"beforeBegin",anim,function(){_5ac=_5ab.getTransform();this.curve=new _575(args.transform,_5ac);});d.connect(anim,"onAnimate",_5ab,"setTransform");return anim;};})();}if(!dojo._hasResource["dojox.charting.action2d.Base"]){dojo._hasResource["dojox.charting.action2d.Base"]=true;dojo.provide("dojox.charting.action2d.Base");(function(){var _5ad=400,_5ae=dojo.fx.easing.backOut,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.Base",null,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_5b0,plot,_5b2){this.chart=_5b0;this.plot=plot?plot:"default";this.anim={};if(!_5b2){_5b2={};}this.duration=_5b2.duration?_5b2.duration:_5ad;this.easing=_5b2.easing?_5b2.easing:_5ae;},connect:function(){this.handle=this.chart.connectToPlot(this.plot,this,"process");},disconnect:function(){if(this.handle){dojo.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){if(this.handle){this.disconnect();}df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});})();}if(!dojo._hasResource["dojox.charting.action2d.Highlight"]){dojo._hasResource["dojox.charting.action2d.Highlight"]=true;dojo.provide("dojox.charting.action2d.Highlight");(function(){var _5b5=100,_5b6=75,_5b7=50,c=dojox.color,cc=function(_5ba){return function(){return _5ba;};},hl=function(_5bc){var a=new c.Color(_5bc),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_5b5;if(x.l<_5b7){x.l=_5b6;}else{if(x.l>_5b6){x.l=_5b7;}else{x.l=x.l-_5b7>_5b6-x.l?_5b7:_5b6;}}}return c.fromHsl(x);};dojo.declare("dojox.charting.action2d.Highlight",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut},optionalParams:{highlight:"red"},constructor:function(_5bf,plot,_5c1){var a=_5c1&&_5c1.highlight;this.colorFun=a?(dojo.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _5c4=o.run.name,_5c5=o.index,anim,_5c7,_5c8;if(_5c4 in this.anim){anim=this.anim[_5c4][_5c5];}else{this.anim[_5c4]={};}if(anim){anim.action.stop(true);}else{var _5c9=o.shape.getFill();if(!_5c9||!(_5c9 instanceof dojo.Color)){return;}this.anim[_5c4][_5c5]=anim={start:_5c9,end:this.colorFun(_5c9)};}var _5ca=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_5ca;_5ca=end;end=t;}anim.action=dojox.gfx.fx.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_5ca,end:end}});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_5c4]){delete this.anim[_5c4][_5c5];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.charting.action2d.Magnify"]){dojo._hasResource["dojox.charting.action2d.Magnify"]=true;dojo.provide("dojox.charting.action2d.Magnify");(function(){var _5cd=2,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Magnify",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:_5cd},optionalParams:{},constructor:function(_5d0,plot,_5d2){this.scale=_5d2&&typeof _5d2.scale=="number"?_5d2.scale:_5cd;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}var _5d4=o.run.name,_5d5=o.index,_5d6=[],anim,init,_5d9;if(_5d4 in this.anim){anim=this.anim[_5d4][_5d5];}else{this.anim[_5d4]={};}if(anim){anim.action.stop(true);}else{this.anim[_5d4][_5d5]=anim={};}if(o.type=="onmouseover"){init=m.identity;_5d9=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_5d9=1/this.scale;}var _5da={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_5d9,o.cx,o.cy]},init]};if(o.shape){_5d6.push(gf.animateTransform(_5da));}if(o.oultine){_5da.shape=o.outline;_5d6.push(gf.animateTransform(_5da));}if(o.shadow){_5da.shape=o.shadow;_5d6.push(gf.animateTransform(_5da));}if(!_5d6.length){delete this.anim[_5d4][_5d5];return;}anim.action=dojo.fx.combine(_5d6);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_5d4]){delete this.anim[_5d4][_5d5];}});}anim.action.play();}});})();}if(!dojo._hasResource["dojox.lang.functional.scan"]){dojo._hasResource["dojox.lang.functional.scan"]=true;dojo.provide("dojox.lang.functional.scan");(function(){var d=dojo,df=dojox.lang.functional,_5dd={};d.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _5dd)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var t,n,z,_5eb=true;if(d.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(var i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(var i in a){if(!(i in _5dd)){if(_5eb){t=[z=a[i]];_5eb=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});})();}if(!dojo._hasResource["dojox.charting.action2d.MoveSlice"]){dojo._hasResource["dojox.charting.action2d.MoveSlice"]=true;dojo.provide("dojox.charting.action2d.MoveSlice");(function(){var _5fb=1.05,_5fc=7,m=dojox.gfx.matrix,gf=dojox.gfx.fx,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.MoveSlice",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:_5fb,shift:_5fc},optionalParams:{},constructor:function(_600,plot,_602){if(!_602){_602={};}this.scale=typeof _602.scale=="number"?_602.scale:_5fb;this.shift=typeof _602.shift=="number"?_602.shift:_5fc;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _604=o.index,anim,_606,_607,_608,_609=(this.angles[_604]+this.angles[_604+1])/2,_60a=m.rotateAt(-_609,o.cx,o.cy),_60b=m.rotateAt(_609,o.cx,o.cy);anim=this.anim[_604];if(anim){anim.action.stop(true);}else{this.anim[_604]=anim={};}if(o.type=="onmouseover"){_607=0;_608=this.shift;_606=this.scale;}else{_607=this.shift;_608=0;_606=1/this.scale;}anim.action=dojox.gfx.fx.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_60b,{name:"translate",start:[_607,0],end:[_608,0]},{name:"scaleAt",start:[1,o.cx,o.cy],end:[_606,o.cx,o.cy]},_60a]});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){delete this.anim[_604];});}anim.action.play();},reset:function(){delete this.angles;}});})();}if(!dojo._hasResource["dojox.charting.action2d.Shake"]){dojo._hasResource["dojox.charting.action2d.Shake"]=true;dojo.provide("dojox.charting.action2d.Shake");(function(){var _60c=3,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Shake",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,shiftX:_60c,shiftY:_60c},optionalParams:{},constructor:function(_60f,plot,_611){if(!_611){_611={};}this.shiftX=typeof _611.shiftX=="number"?_611.shiftX:_60c;this.shiftY=typeof _611.shiftY=="number"?_611.shiftY:_60c;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _613=o.run.name,_614=o.index,_615=[],anim,_617=o.type=="onmouseover"?this.shiftX:-this.shiftX,_618=o.type=="onmouseover"?this.shiftY:-this.shiftY;if(_613 in this.anim){anim=this.anim[_613][_614];}else{this.anim[_613]={};}if(anim){anim.action.stop(true);}else{this.anim[_613][_614]=anim={};}var _619={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_615.push(gf.animateTransform(_619));}if(o.oultine){_619.shape=o.outline;_615.push(gf.animateTransform(_619));}if(o.shadow){_619.shape=o.shadow;_615.push(gf.animateTransform(_619));}if(!_615.length){delete this.anim[_613][_614];return;}anim.action=dojo.fx.combine(_615);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[_613]){delete this.anim[_613][_614];}});}anim.action.play();}});})();}if(!dojo._hasResource["dijit.Tooltip"]){dojo._hasResource["dijit.Tooltip"]=true;dojo.provide("dijit.Tooltip");dojo.declare("dijit._MasterTooltip",[dijit._Widget,dijit._Templated],{duration:dijit.defaultDuration,templateString:"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\">\n\t<div class=\"dijitTooltipContainer dijitTooltipContents\" dojoAttachPoint=\"containerNode\" waiRole='alert'></div>\n\t<div class=\"dijitTooltipConnector\"></div>\n</div>\n",postCreate:function(){dojo.body().appendChild(this.domNode);this.bgIframe=new dijit.BackgroundIframe(this.domNode);this.fadeIn=dojo.fadeIn({node:this.domNode,duration:this.duration,onEnd:dojo.hitch(this,"_onShow")});this.fadeOut=dojo.fadeOut({node:this.domNode,duration:this.duration,onEnd:dojo.hitch(this,"_onHide")});},show:function(_61a,_61b,_61c){if(this.aroundNode&&this.aroundNode===_61b){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_61a;this.domNode.style.top=(this.domNode.offsetTop+1)+"px";var _61d={};var ltr=this.isLeftToRight();dojo.forEach((_61c&&_61c.length)?_61c:dijit.Tooltip.defaultPosition,function(pos){switch(pos){case "after":_61d[ltr?"BR":"BL"]=ltr?"BL":"BR";break;case "before":_61d[ltr?"BL":"BR"]=ltr?"BR":"BL";break;case "below":_61d[ltr?"BL":"BR"]=ltr?"TL":"TR";_61d[ltr?"BR":"BL"]=ltr?"TR":"TL";break;case "above":default:_61d[ltr?"TL":"TR"]=ltr?"BL":"BR";_61d[ltr?"TR":"TL"]=ltr?"BR":"BL";break;}});var pos=dijit.placeOnScreenAroundElement(this.domNode,_61b,_61d,dojo.hitch(this,"orient"));dojo.style(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_61b;},orient:function(node,_622,_623){node.className="dijitTooltip "+{"BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_622+"-"+_623];},_onShow:function(){if(dojo.isIE){this.domNode.style.filter="";}},hide:function(_624){if(this._onDeck&&this._onDeck[1]==_624){this._onDeck=null;}else{if(this.aroundNode===_624){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});dijit.showTooltip=function(_625,_626,_627){if(!dijit._masterTT){dijit._masterTT=new dijit._MasterTooltip();}return dijit._masterTT.show(_625,_626,_627);};dijit.hideTooltip=function(_628){if(!dijit._masterTT){dijit._masterTT=new dijit._MasterTooltip();}return dijit._masterTT.hide(_628);};dojo.declare("dijit.Tooltip",dijit._Widget,{label:"",showDelay:400,connectId:[],position:[],_setConnectIdAttr:function(ids){this._connectNodes=[];this.connectId=dojo.isArrayLike(ids)?ids:[ids];dojo.forEach(this.connectId,function(id){var node=dojo.byId(id);if(node){this._connectNodes.push(node);dojo.forEach(["onMouseEnter","onMouseLeave","onFocus","onBlur"],function(_62c){this.connect(node,_62c.toLowerCase(),"_"+_62c);},this);if(dojo.isIE){node.style.zoom=1;}}},this);},postCreate:function(){dojo.addClass(this.domNode,"dijitTooltipData");},_onMouseEnter:function(e){this._onHover(e);},_onMouseLeave:function(e){this._onUnHover(e);},_onFocus:function(e){this._focus=true;this._onHover(e);this.inherited(arguments);},_onBlur:function(e){this._focus=false;this._onUnHover(e);this.inherited(arguments);},_onHover:function(e){if(!this._showTimer){var _632=e.target;this._showTimer=setTimeout(dojo.hitch(this,function(){this.open(_632);}),this.showDelay);}},_onUnHover:function(e){if(this._focus){return;}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}this.close();},open:function(_634){_634=_634||this._connectNodes[0];if(!_634){return;}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}dijit.showTooltip(this.label||this.domNode.innerHTML,_634,this.position);this._connectNode=_634;},close:function(){if(this._connectNode){dijit.hideTooltip(this._connectNode);delete this._connectNode;}if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}},uninitialize:function(){this.close();}});dijit.Tooltip.defaultPosition=["after","before"];}if(!dojo._hasResource["dojox.charting.action2d.Tooltip"]){dojo._hasResource["dojox.charting.action2d.Tooltip"]=true;dojo.provide("dojox.charting.action2d.Tooltip");(function(){var _635=function(o){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t=="object"&&t.tooltip){return t.tooltip;}return o.element=="bar"?o.x:o.y;};var df=dojox.lang.functional,pi4=Math.PI/4,pi2=Math.PI/2;dojo.declare("dojox.charting.action2d.Tooltip",dojox.charting.action2d.Base,{defaultParams:{text:_635},optionalParams:{},constructor:function(_63b,plot,_63d){this.text=_63d&&_63d.text?_63d.text:_635;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){dijit.hideTooltip(this.aroundRect);this.aroundRect=null;return;}if(!o.shape||o.type!=="onmouseover"){return;}var _63f={type:"rect"},_640=["after","before"];switch(o.element){case "marker":_63f.x=o.cx;_63f.y=o.cy;_63f.width=_63f.height=1;break;case "circle":_63f.x=o.cx-o.cr;_63f.y=o.cy-o.cr;_63f.width=_63f.height=2*o.cr;break;case "column":_640=["above","below"];case "bar":_63f=dojo.clone(o.shape.getShape());break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _641=(this.angles[o.index]+this.angles[o.index+1])/2;_63f.x=o.cx+o.cr*Math.cos(_641);_63f.y=o.cy+o.cr*Math.sin(_641);_63f.width=_63f.height=1;if(_641<pi4){}else{if(_641<pi2+pi4){_640=["below","above"];}else{if(_641<Math.PI+pi4){_640=["before","after"];}else{if(_641<2*Math.PI-pi4){_640=["above","below"];}}}}break;}var lt=dojo.coords(this.chart.node,true);_63f.x+=lt.x;_63f.y+=lt.y;_63f.x=Math.round(_63f.x);_63f.y=Math.round(_63f.y);_63f.width=Math.ceil(_63f.width);_63f.height=Math.ceil(_63f.height);this.aroundRect=_63f;dijit.showTooltip(this.text(o),this.aroundRect,_640);}});})();}if(!dojo._hasResource["dojox.charting.widget.Chart2D"]){dojo._hasResource["dojox.charting.widget.Chart2D"]=true;dojo.provide("dojox.charting.widget.Chart2D");(function(){var _643,_644,_645,_646,_647,_648=function(o){return o;},df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting,d=dojo;dojo.declare("dojox.charting.widget.Chart2D",dijit._Widget,{theme:null,margins:null,stroke:null,fill:null,buildRendering:function(){var n=this.domNode=this.srcNodeRef;var axes=d.query("> .axis",n).map(_644).filter(_648),_650=d.query("> .plot",n).map(_645).filter(_648),_651=d.query("> .action",n).map(_646).filter(_648),_652=d.query("> .series",n).map(_647).filter(_648);n.innerHTML="";var c=this.chart=new dc.Chart2D(n,{margins:this.margins,stroke:this.stroke,fill:this.fill});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_650.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_651.map(function(_656){return new _656.action(c,_656.plot,_656.kwArgs);});var _657=df.foldl(_652,function(_658,_659){if(_659.type=="data"){c.addSeries(_659.name,_659.data,_659.kwArgs);_658=true;}else{c.addSeries(_659.name,[0],_659.kwArgs);var kw={};du.updateWithPattern(kw,_659.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_659.kwArgs.sort){kw.sort=dojo.clone(_659.kwArgs.sort);}d.mixin(kw,{onComplete:function(data){var _65c;if("valueFn" in _659.kwArgs){var fn=_659.kwArgs.valueFn;_65c=d.map(data,function(x){return fn(_659.data.getValue(x,_659.field,0));});}else{_65c=d.map(data,function(x){return _659.data.getValue(x,_659.field,0);});}c.addSeries(_659.name,_65c,_659.kwArgs).render();}});_659.data.fetch(kw);}return _658;},false);if(_657){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){if(box.w>0&&box.h>0){dojo.marginBox(this.domNode,box);this.chart.resize();}}});_643=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_644=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=dojox._scopeName+".charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=dojox._scopeName+".charting.axis2d.Default";}_643(node,type,kw);return o;};_645=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d[type]){type=dojox._scopeName+".charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=dojox._scopeName+".charting.plot2d.Default";}_643(node,type,kw);return o;};_646=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=dojox._scopeName+".charting.action2d."+type;}var _679=eval("("+type+")");if(!_679){return null;}o.action=_679;}else{return null;}_643(node,type,kw);return o;};_647=function(node){var ga=d.partial(d.attr,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=dojo.map(String(t).split(","),Number);return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=df.lambda(t);}return o;}return null;};})();}if(!dojo._hasResource["dojox.charting.themes.ET.greys"]){dojo._hasResource["dojox.charting.themes.ET.greys"]=true;dojo.provide("dojox.charting.themes.ET.greys");dojo.deprecated("dojox.charting.themes.ET.greys","1.3");(function(){var dxc=dojox.charting;dxc.themes.ET.greys=new dxc.Theme({antiAlias:false,chart:{stroke:null,fill:"inherit"},plotarea:{stroke:null,fill:"transparent"},axis:{stroke:{width:0},line:{width:0},majorTick:{color:"#666666",width:1,length:5},minorTick:{color:"black",width:0.5,length:2},font:"normal normal normal 8pt Tahoma",fontColor:"#999999"},series:{outline:{width:0,color:"black"},stroke:{width:1,color:"black"},fill:dojo.colorFromHex("#3b444b"),font:"normal normal normal 7pt Tahoma",fontColor:"#717171"},marker:{stroke:{width:1},fill:"#333",font:"normal normal normal 7pt Tahoma",fontColor:"#000"},colors:[dojo.colorFromHex("#8a8c8f"),dojo.colorFromHex("#4b4b4b"),dojo.colorFromHex("#3b444b"),dojo.colorFromHex("#2e2d30"),dojo.colorFromHex("#000000")]});})();}if(!dojo._hasResource["dojox.charting.widget.Sparkline"]){dojo._hasResource["dojox.charting.widget.Sparkline"]=true;dojo.provide("dojox.charting.widget.Sparkline");(function(){var d=dojo;dojo.declare("dojox.charting.widget.Sparkline",dojox.charting.widget.Chart2D,{theme:dojox.charting.themes.ET.greys,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!d.query("> .axis, > .plot, > .action, > .series",n).length){var plot=document.createElement("div");d.attr(plot,{"class":"plot","name":"default","type":this.type});n.appendChild(plot);var _684=document.createElement("div");d.attr(_684,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});d.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){d.attr(_684,i,this[i]);}},this);n.appendChild(_684);}this.inherited(arguments);}});})();}if(!dojo._hasResource["dojox.charting.widget.Legend"]){dojo._hasResource["dojox.charting.widget.Legend"]=true;dojo.provide("dojox.charting.widget.Legend");dojo.declare("dojox.charting.widget.Legend",[dijit._Widget,dijit._Templated],{chartRef:"",horizontal:true,templateString:"<table dojoAttachPoint='legendNode' class='dojoxLegendNode'><tbody dojoAttachPoint='legendBody'></tbody></table>",legendNode:null,legendBody:null,postCreate:function(){if(!this.chart){if(!this.chartRef){return;}this.chart=dijit.byId(this.chartRef);if(!this.chart){var node=dojo.byId(this.chartRef);if(node){this.chart=dijit.byNode(node);}else{return;}}this.series=this.chart.chart.series;}else{this.series=this.chart.series;}this.refresh();},refresh:function(){var df=dojox.lang.functional;if(this._surfaces){dojo.forEach(this._surfaces,function(_688){_688.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){dojo.destroy(this.legendBody.lastChild);}if(this.horizontal){dojo.addClass(this.legendNode,"dojoxLegendHorizontal");this._tr=dojo.doc.createElement("tr");this.legendBody.appendChild(this._tr);}var s=this.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _68b=df.map(t.run.data,"Math.max(x, 0)");if(df.every(_68b,"<= 0")){return;}var _68c=df.map(_68b,"/this",df.foldl(_68b,"+",0));dojo.forEach(_68c,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{dojo.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{dojo.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_693){var icon=dojo.doc.createElement("td"),text=dojo.doc.createElement("td"),div=dojo.doc.createElement("div");dojo.addClass(icon,"dojoxLegendIcon");dojo.addClass(text,"dojoxLegendText");div.style.width="20px";div.style.height="20px";icon.appendChild(div);if(this._tr){this._tr.appendChild(icon);this._tr.appendChild(text);}else{var tr=dojo.doc.createElement("tr");this.legendBody.appendChild(tr);tr.appendChild(icon);tr.appendChild(text);}this._makeIcon(div,dyn);text.innerHTML=String(_693);},_makeIcon:function(div,dyn){var mb={h:14,w:14};var _69b=dojox.gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_69b);if(dyn.fill){_69b.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_69b.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};if(dyn.stroke){_69b.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.stroke.color).setStroke(dyn.stroke);}else{_69b.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.color).setStroke(dyn.color);}}}else{_69b.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_69b.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_69b.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});}
