/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

/**
 * Unit test for consuming the single directory only.
 */
public class FileConsumeSingleDirectoryOnlyTest extends ContextTestSupport {

    @Override
    protected void setUp() throws Exception {
        deleteDirectory("target/singledirectoryonly");
        super.setUp();
        template.sendBodyAndHeader("file://target/singledirectoryonly", "Hello World", Exchange.FILE_NAME, "report.txt");
        template.sendBodyAndHeader("file://target/singledirectoryonly", "Bye World", Exchange.FILE_NAME, "report2.txt");
        template.sendBodyAndHeader("file://target/singledirectoryonly/2008", "2008 Report", Exchange.FILE_NAME, "report2008.txt");
    }

    public void testConsumeFileOnly() throws Exception {
        MockEndpoint mock = getMockEndpoint("mock:result");
        // Default wait time of 10 sec is not quite long enough on slow
        // machines.
        mock.setResultWaitTime(15000L);
        mock.expectedBodiesReceivedInAnyOrder("Hello World", "Bye World");

        assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            public void configure() throws Exception {
                from("file://target/singledirectoryonly/?recursive=false&delete=true")
                        .convertBodyTo(String.class).to("mock:result");
            }
        };
    }
}
