/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.apache.camel.Message;
import org.apache.camel.component.xmlsecurity.api.XmlSignature2Message;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureException;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXmlSignature2Message
implements XmlSignature2Message {
    public static final String OUTPUT_NODE_SEARCH_TYPE_DEFAULT = "Default";
    public static final String OUTPUT_NODE_SEARCH_TYPE_ELEMENT_NAME = "ElementName";
    public static final String OUTPUT_NODE_SEARCH_TYPE_XPATH = "XPath";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultXmlSignature2Message.class);

    @Override
    public void mapToMessage(XmlSignature2Message.Input input, Message output) throws Exception {
        Node node;
        boolean removeSignatureElements = false;
        if (OUTPUT_NODE_SEARCH_TYPE_DEFAULT.equals(input.getOutputNodeSearchType())) {
            LOG.debug("Searching for output node via default search");
            if (this.isEnveloped(input)) {
                node = input.getMessageBodyDocument().getDocumentElement();
                removeSignatureElements = true;
            } else {
                node = this.getNodeForMessageBodyInNonEnvelopedCase(input);
            }
        } else if (OUTPUT_NODE_SEARCH_TYPE_ELEMENT_NAME.equals(input.getOutputNodeSearchType())) {
            node = this.getOutputElementViaLocalNameAndNamespace(input);
        } else if (OUTPUT_NODE_SEARCH_TYPE_XPATH.equals(input.getOutputNodeSearchType())) {
            node = this.getOutputNodeViaXPath(input);
        } else {
            throw new XmlSignatureException(String.format("Wrong configuration: The output node search type %s is not supported.", input.getOutputNodeSearchType()));
        }
        LOG.debug("Output node with local name {} and namespace {} found", (Object)node.getLocalName(), (Object)node.getNamespaceURI());
        if (!removeSignatureElements) {
            boolean bl = removeSignatureElements = input.getRemoveSignatureElements() != null && input.getRemoveSignatureElements() != false;
        }
        if (removeSignatureElements) {
            this.removeSignatureElements(node);
        }
        this.transformNodeToByteArrayAndSetToOutputMessage(input, output, node);
    }

    protected void transformNodeToByteArrayAndSetToOutputMessage(XmlSignature2Message.Input input, Message output, Node node) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XmlSignatureHelper.transformToOutputStream(node, os, this.omitXmlDeclaration(output, input));
        output.setBody((Object)os.toByteArray());
    }

    protected Node getOutputNodeViaXPath(XmlSignature2Message.Input input) throws Exception {
        this.checkSearchValueNotNull(input);
        this.checkSearchValueOfType(XPathFilterParameterSpec.class, input);
        XPathFilterParameterSpec xpathFilter = (XPathFilterParameterSpec)input.getOutputNodeSearch();
        XPathExpression expr = XmlSignatureHelper.getXPathExpression(xpathFilter);
        NodeList nodes = (NodeList)expr.evaluate(input.getMessageBodyDocument(), XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            throw new XmlSignatureException(String.format("Cannot extract root node for the output document from the XML signature document. No node found for XPATH %s as specified in the output node search.", xpathFilter.getXPath()));
        }
        if (nodes.getLength() > 1) {
            throw new XmlSignatureException(String.format("Cannot extract root node for the output document from the XML signature document. XPATH %s as specified in the output node search results into more than one child.", xpathFilter.getXPath()));
        }
        Node result = nodes.item(0);
        if (1 == result.getNodeType() || 3 == result.getNodeType() || 9 == result.getNodeType()) {
            return result;
        }
        throw new XmlSignatureException(String.format("Cannot extract root node for the output document from the XML signature document. XPATH %s as specified in the output node search results into a node which has the wrong type.", xpathFilter.getXPath()));
    }

    protected Node getOutputElementViaLocalNameAndNamespace(XmlSignature2Message.Input input) throws Exception {
        String localName;
        String namespace;
        String search = this.getNonEmptyStringSearchValue(input);
        if ('{' == search.charAt(0)) {
            int index = search.indexOf(125);
            if (index < 1) {
                throw new XmlSignatureException(String.format("Wrong configuration: Value %s for the output node search %s has wrong format. Value must have the form '{<namespace>}<element local name>' or '<element local name>' if no the element has no namespace.", search, input.getOutputNodeSearchType()));
            }
            namespace = search.substring(1, index);
            if (search.length() < index + 1) {
                throw new XmlSignatureException(String.format("Wrong configuration: Value %s for the output node search %s has wrong format. Value must have the form '{<namespace>}<element local name>' or '<element local name>' if no the element has no namespace.", search, input.getOutputNodeSearchType()));
            }
            localName = search.substring(index + 1);
        } else {
            namespace = null;
            localName = search;
        }
        NodeList nodeList = input.getMessageBodyDocument().getElementsByTagNameNS(namespace, localName);
        if (nodeList.getLength() == 0) {
            throw new XmlSignatureException(String.format("Cannot extract root element for the output document from the XML signature document. Element with local name %s and namespace %s does not exist.", namespace, localName));
        }
        if (nodeList.getLength() > 1) {
            throw new XmlSignatureException(String.format("Cannot extract root element for the output document from the XML signature document. More than one element found with local name %s and namespace %s.", namespace, localName));
        }
        return nodeList.item(0);
    }

    protected String getNonEmptyStringSearchValue(XmlSignature2Message.Input input) throws Exception {
        this.checkSearchValueNotNull(input);
        this.checkSearchValueOfType(String.class, input);
        String search = (String)input.getOutputNodeSearch();
        this.checkStringSarchValueNotEmpty(search, input.getOutputNodeSearchType());
        return search;
    }

    protected void checkSearchValueOfType(Class<?> cl, XmlSignature2Message.Input input) throws Exception {
        if (!cl.isAssignableFrom(input.getOutputNodeSearch().getClass())) {
            throw new XMLSignatureException(String.format("Wrong configruation: Search value is of class %s, the output node search %s requires class %s.", input.getOutputNodeSearch().getClass().getName(), input.getOutputNodeSearchType(), cl.getName()));
        }
    }

    protected void checkStringSarchValueNotEmpty(String searchValue, String outputNodeSearchType) throws Exception {
        if (searchValue.isEmpty()) {
            throw new XMLSignatureException(String.format("Wrong configruation: Value for output node search %s is empty.", outputNodeSearchType));
        }
    }

    protected void checkSearchValueNotNull(XmlSignature2Message.Input input) throws Exception {
        LOG.debug("Searching for output element with search value '{}' and sarch type {}", input.getOutputNodeSearch(), (Object)input.getOutputNodeSearchType());
        if (input.getOutputNodeSearch() == null) {
            throw new XMLSignatureException(String.format("Wrong configruation: Value is missing for output node search %s.", input.getOutputNodeSearchType()));
        }
    }

    protected Node getNodeForMessageBodyInNonEnvelopedCase(XmlSignature2Message.Input input) throws Exception {
        List<Reference> relevantReferences = this.getReferencesForMessageMapping(input);
        List<XMLObject> relevantObjects = this.getObjectsForMessageMapping(input);
        DOMStructure domStruc = this.getDomStructureForMessageBody(relevantReferences, relevantObjects);
        Node node = domStruc.getNode();
        return node;
    }

    protected void removeSignatureElements(Node node) {
        Document doc = XmlSignatureHelper.getDocument(node);
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            Node parent = n.getParentNode();
            if (parent == null) continue;
            parent.removeChild(n);
        }
    }

    protected boolean isEnveloped(XmlSignature2Message.Input input) throws Exception {
        for (Reference ref : input.getReferences()) {
            if (!"".equals(ref.getURI())) continue;
            for (Transform t : ref.getTransforms()) {
                if (!"http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(t.getAlgorithm())) continue;
                return true;
            }
        }
        return false;
    }

    protected Boolean omitXmlDeclaration(Message message, XmlSignature2Message.Input input) {
        Boolean omitXmlDeclaration = (Boolean)message.getHeader("CamelXmlSignatureOmitXmlDeclaration", Boolean.class);
        if (omitXmlDeclaration == null) {
            omitXmlDeclaration = input.omitXmlDeclaration();
        }
        if (omitXmlDeclaration == null) {
            omitXmlDeclaration = Boolean.FALSE;
        }
        return omitXmlDeclaration;
    }

    protected List<Reference> getReferencesForMessageMapping(XmlSignature2Message.Input input) throws Exception {
        return input.getReferences();
    }

    protected List<XMLObject> getObjectsForMessageMapping(XmlSignature2Message.Input input) throws Exception {
        return input.getObjects();
    }

    protected DOMStructure getDomStructureForMessageBody(List<Reference> relevantReferences, List<XMLObject> relevantObjects) throws Exception {
        List<XMLObject> referencedObjects = this.getReferencedSameDocumentObjects(relevantReferences, relevantObjects);
        if (referencedObjects.isEmpty()) {
            throw new XmlSignatureException(String.format("Unsupported XML signature document: Content object not found in the XML signature. Detached or enveloped signatures are not supported.", new Object[0]));
        }
        if (referencedObjects.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < referencedObjects.size(); ++i) {
                XMLObject xmlOb = referencedObjects.get(i);
                sb.append(xmlOb.getId());
                if (i >= referencedObjects.size() - 1) continue;
                sb.append(", ");
            }
            throw new XmlSignatureException(String.format("Unsupported XML signature document: More than one content objects found. Object IDs: %s", sb.toString()));
        }
        List<XMLStructure> structures = referencedObjects.get(0).getContent();
        if (structures.size() == 0) {
            throw new XmlSignatureException("Unsupported XML signature: XML signature is not enveloping; content not found in XML signature: structure list is empty.");
        }
        if (structures.size() > 1) {
            throw new XmlSignatureException("Unsupported XML signature: more than one structure elements in referenced content object.");
        }
        XMLStructure structure = structures.get(0);
        DOMStructure domStruc = (DOMStructure)structure;
        return domStruc;
    }

    protected List<XMLObject> getReferencedSameDocumentObjects(List<Reference> relevantReferences, List<XMLObject> relevantObjects) {
        ArrayList<XMLObject> referencedObjects = new ArrayList<XMLObject>(1);
        for (Reference ref : relevantReferences) {
            String refUri = this.getSameDocumentReferenceUri(ref);
            if (refUri == null) continue;
            XMLObject referencedOb = this.getReferencedObject(relevantObjects, refUri);
            if (referencedOb != null) {
                referencedObjects.add(referencedOb);
                continue;
            }
            this.addManifestReferencedObjects(relevantObjects, referencedObjects, refUri);
        }
        return referencedObjects;
    }

    protected void addManifestReferencedObjects(List<XMLObject> allObjects, List<XMLObject> referencedObjects, String manifestId) {
        Manifest manifest = this.getReferencedManifest(allObjects, manifestId);
        if (manifest == null) {
            return;
        }
        for (Reference manifestRef : manifest.getReferences()) {
            XMLObject manifestReferencedOb;
            String manifestRefUri = this.getSameDocumentReferenceUri(manifestRef);
            if (manifestRefUri == null || (manifestReferencedOb = this.getReferencedObject(allObjects, manifestRefUri)) == null) continue;
            referencedObjects.add(manifestReferencedOb);
        }
    }

    protected String getSameDocumentReferenceUri(Reference ref) {
        String refUri = ref.getURI();
        if (refUri == null) {
            LOG.warn("Ignoring reference {} which has no URI", (Object)ref);
            return null;
        }
        if (!refUri.startsWith("#")) {
            LOG.warn("Ignoring non-same document reference {}", (Object)refUri);
            return null;
        }
        return refUri.substring(1);
    }

    protected Manifest getReferencedManifest(List<XMLObject> objects, String id) {
        for (XMLObject xo : objects) {
            List<XMLStructure> content = xo.getContent();
            for (XMLStructure xs : content) {
                Manifest man;
                if (!(xs instanceof Manifest) || !id.equals((man = (Manifest)xs).getId())) continue;
                return man;
            }
        }
        return null;
    }

    protected XMLObject getReferencedObject(List<XMLObject> objects, String id) {
        for (XMLObject ob : objects) {
            if (!id.equals(ob.getId())) continue;
            return ob;
        }
        return null;
    }
}

