/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.net.URI;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.ObjectHelper;
import org.apache.sshd.common.KeyPairProvider;

@UriParams
public class SshConfiguration
implements Cloneable {
    public static final int DEFAULT_SSH_PORT = 22;
    @UriParam
    private String username;
    @UriParam
    private String host;
    @UriParam
    private int port = 22;
    @UriParam
    private String password;
    @UriParam
    private String pollCommand;
    private KeyPairProvider keyPairProvider;
    @UriParam
    private String keyType = "ssh-rsa";
    @UriParam
    private String certResource;
    @UriParam
    private long timeout = 30000L;

    public SshConfiguration() {
    }

    public SshConfiguration(URI uri) {
        this.configure(uri);
    }

    public void configure(URI uri) {
        String username = uri.getUserInfo();
        String pw = null;
        if (username != null && username.contains(":")) {
            pw = ObjectHelper.after((String)username, (String)":");
            username = ObjectHelper.before((String)username, (String)":");
        }
        if (username != null) {
            this.setUsername(username);
        }
        if (pw != null) {
            this.setPassword(pw);
        }
        this.setHost(uri.getHost());
        int uriPort = uri.getPort();
        if (uriPort != -1) {
            this.setPort(uriPort);
        }
    }

    public SshConfiguration copy() {
        try {
            return (SshConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPollCommand() {
        return this.pollCommand;
    }

    public void setPollCommand(String pollCommand) {
        this.pollCommand = pollCommand;
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.keyPairProvider;
    }

    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.keyPairProvider = keyPairProvider;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getCertFilename() {
        return this.certResource != null && this.certResource.startsWith("file:") ? this.certResource.substring(5) : null;
    }

    public void setCertFilename(String certFilename) {
        this.certResource = "file:" + certFilename;
    }

    public String getCertResource() {
        return this.certResource;
    }

    public void setCertResource(String certResource) {
        this.certResource = certResource;
    }
}

