/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.io.IOException;
import java.util.Collection;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.websocket.DefaultWebsocket;
import org.apache.camel.component.websocket.WebsocketEndpoint;
import org.apache.camel.component.websocket.WebsocketProducerConsumer;
import org.apache.camel.component.websocket.WebsocketStore;
import org.apache.camel.impl.DefaultProducer;

public class WebsocketProducer
extends DefaultProducer
implements WebsocketProducerConsumer {
    private final WebsocketStore store;
    private final Boolean sendToAll;
    private final WebsocketEndpoint endpoint;

    public WebsocketProducer(WebsocketEndpoint endpoint, WebsocketStore store) {
        super((Endpoint)endpoint);
        this.store = store;
        this.sendToAll = endpoint.getSendToAll();
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String message = (String)in.getMandatoryBody(String.class);
        if (this.isSendToAllSet(in)) {
            this.sendToAll(this.store, message, exchange);
        } else {
            String connectionKey = (String)in.getHeader("websocket.connectionKey", String.class);
            if (connectionKey != null) {
                DefaultWebsocket websocket = this.store.get(connectionKey);
                this.log.debug("Sending to connection key {} -> {}", (Object)connectionKey, (Object)message);
                this.sendMessage(websocket, message);
            } else {
                throw new IllegalArgumentException("Failed to send message to single connection; connetion key not set.");
            }
        }
    }

    @Override
    public WebsocketEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void start() throws Exception {
        super.start();
        this.endpoint.connect(this);
    }

    public void stop() throws Exception {
        this.endpoint.disconnect(this);
        super.stop();
    }

    boolean isSendToAllSet(Message in) {
        Boolean value = (Boolean)in.getHeader("websocket.sendToAll", (Object)this.sendToAll, Boolean.class);
        return value == null ? false : value;
    }

    void sendToAll(WebsocketStore store, String message, Exchange exchange) throws Exception {
        this.log.debug("Sending to all {}", (Object)message);
        Collection<DefaultWebsocket> websockets = store.getAll();
        CamelExchangeException exception = null;
        for (DefaultWebsocket websocket : websockets) {
            try {
                this.sendMessage(websocket, message);
            }
            catch (Exception e) {
                if (exception != null) continue;
                exception = new CamelExchangeException("Failed to deliver message to one or more recipients.", exchange, (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    void sendMessage(DefaultWebsocket websocket, String message) throws IOException {
        if (websocket != null && websocket.getConnection().isOpen()) {
            this.log.trace("Sending to websocket {} -> {}", (Object)websocket.getConnectionKey(), (Object)message);
            websocket.getConnection().sendMessage(message);
        }
    }
}

