/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlrpc;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.xmlrpc.XmlRpcAsyncCallback;
import org.apache.camel.component.xmlrpc.XmlRpcEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRpcProducer
extends DefaultProducer
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlRpcProducer.class);
    private XmlRpcEndpoint endpoint;
    private XmlRpcClient client;

    public XmlRpcProducer(XmlRpcEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        LOG.trace("Process exchange: {} in the sync way.", (Object)exchange);
        Message in = exchange.getIn();
        String operationName = (String)in.getHeader("CamelXmlRpcMethodName", String.class);
        Object result = this.client.execute(operationName, (List)in.getBody(List.class));
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        exchange.getOut().setBody(result);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        LOG.trace("Process exchange: {} in the async way.", (Object)exchange);
        Message in = exchange.getIn();
        String operationName = (String)in.getHeader("CamelXmlRpcMethodName", String.class);
        XmlRpcAsyncCallback xmlRpcAsyncCallback = new XmlRpcAsyncCallback(exchange, callback);
        try {
            this.client.executeAsync(operationName, (List)in.getBody(List.class), (org.apache.xmlrpc.client.AsyncCallback)xmlRpcAsyncCallback);
            return false;
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
            callback.done(true);
            return true;
        }
    }

    protected void doStart() throws Exception {
        if (this.client == null) {
            this.client = this.endpoint.createClient();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null) {
            this.client = null;
        }
    }
}

