/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stringtemplate;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.util.ExchangeHelper;
import org.stringtemplate.v4.NoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;

public class StringTemplateEndpoint
extends ResourceEndpoint {
    private char delimiterStart;
    private char delimiterStop;

    public StringTemplateEndpoint() {
        this.delimiterStart = STGroup.defaultGroup.delimiterStartChar;
        this.delimiterStop = STGroup.defaultGroup.delimiterStopChar;
    }

    public StringTemplateEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component, resourceUri);
        this.delimiterStart = STGroup.defaultGroup.delimiterStartChar;
        this.delimiterStop = STGroup.defaultGroup.delimiterStopChar;
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    public char getDelimiterStart() {
        return this.delimiterStart;
    }

    public void setDelimiterStart(char delimiterStart) {
        this.delimiterStart = delimiterStart;
    }

    public char getDelimiterStop() {
        return this.delimiterStop;
    }

    public void setDelimiterStop(char delimiterStop) {
        this.delimiterStop = delimiterStop;
    }

    protected void onExchange(Exchange exchange) throws Exception {
        StringWriter buffer = new StringWriter();
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
        String text = (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)this.getResourceAsInputStream());
        ST template = new ST(text, this.delimiterStart, this.delimiterStop);
        for (Map.Entry entry : variableMap.entrySet()) {
            template.add((String)entry.getKey(), entry.getValue());
        }
        this.log.debug("StringTemplate is writing using attributes: {}", (Object)variableMap);
        template.write((STWriter)new NoIndentWriter((Writer)buffer));
        Message out = exchange.getOut();
        out.setBody((Object)buffer.toString());
        out.setHeaders(exchange.getIn().getHeaders());
        out.setHeader("CamelStringTemplateResourceUri", (Object)this.getResourceUri());
        out.setAttachments(exchange.getIn().getAttachments());
    }
}

