/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.impl;

import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.guice.support.AnnotationMemberProvider;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.util.ObjectHelper;

public class EndpointInjector
extends CamelPostProcessorHelper
implements AnnotationMemberProvider<EndpointInject> {
    @Inject
    public EndpointInjector(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public Object provide(EndpointInject inject, TypeLiteral<?> typeLiteral, Field field) {
        Class<?> type = field.getType();
        String injectionPointName = field.getName();
        String uri = inject.uri();
        String endpointRef = inject.ref();
        String property = inject.property();
        return this.getInjectionValue(type, uri, endpointRef, property, injectionPointName, null, null);
    }

    @Override
    public Object provide(EndpointInject inject, TypeLiteral<?> typeLiteral, Method method, Class<?> aClass, int index) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> type = parameterTypes[index];
        String injectionPointName = ObjectHelper.getPropertyName((Method)method);
        String endpointRef = inject.ref();
        String uri = inject.uri();
        String property = inject.property();
        return this.getInjectionValue(type, uri, endpointRef, property, injectionPointName, null, null);
    }

    @Override
    public boolean isNullParameterAllowed(EndpointInject endpointInject, Method method, Class<?> aClass, int index) {
        return false;
    }
}

