/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.rx.support;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.rx.RuntimeCamelRxException;
import org.apache.camel.util.ServiceHelper;
import rx.Observer;

public class ObserverSender
implements Observer {
    private Producer producer;

    public ObserverSender(Endpoint endpoint) throws Exception {
        this.producer = endpoint.createProducer();
        ServiceHelper.startService((Service)this.producer);
    }

    public void onCompleted() {
        if (this.producer != null) {
            try {
                ServiceHelper.stopService((Object)this.producer);
            }
            catch (Exception e) {
                throw new RuntimeCamelRxException(e);
            }
            finally {
                this.producer = null;
            }
        }
    }

    public void onError(Throwable e) {
        Exchange exchange = this.producer.createExchange();
        exchange.setException(e);
        this.send(exchange);
    }

    public void onNext(Object o) {
        Exchange exchange = this.producer.createExchange();
        exchange.getIn().setBody(o);
        this.send(exchange);
    }

    protected void send(Exchange exchange) {
        try {
            this.producer.process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeCamelRxException(e);
        }
    }
}

