/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.LongSerializationPolicy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;

public class GsonDataFormat
extends ServiceSupport
implements DataFormat {
    private Gson gson;
    private Class<?> unmarshalType;
    private List<ExclusionStrategy> exclusionStrategies;
    private LongSerializationPolicy longSerializationPolicy;
    private FieldNamingPolicy fieldNamingPolicy;
    private FieldNamingStrategy fieldNamingStrategy;
    private Boolean serializeNulls;
    private Boolean prettyPrinting;
    private String dateFormatPattern;

    public GsonDataFormat() {
        this(Map.class);
    }

    public GsonDataFormat(Class<?> unmarshalType) {
        this(null, unmarshalType);
    }

    @Deprecated
    public GsonDataFormat(Class<?> unmarshalType, ExclusionStrategy ... exclusionStrategies) {
        this(null, unmarshalType);
        this.setExclusionStrategies(Arrays.asList(exclusionStrategies));
    }

    public GsonDataFormat(Gson gson, Class<?> unmarshalType) {
        this.gson = gson;
        this.unmarshalType = unmarshalType;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        BufferedWriter writer = IOHelper.buffered((Writer)new OutputStreamWriter(stream, IOHelper.getCharsetName((Exchange)exchange)));
        this.gson.toJson(graph, (Appendable)writer);
        writer.close();
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        BufferedReader reader = IOHelper.buffered((Reader)new InputStreamReader(stream, IOHelper.getCharsetName((Exchange)exchange)));
        Object result = this.gson.fromJson((Reader)reader, this.unmarshalType);
        reader.close();
        return result;
    }

    protected void doStart() throws Exception {
        if (this.gson == null) {
            GsonBuilder builder = new GsonBuilder();
            if (this.exclusionStrategies != null && !this.exclusionStrategies.isEmpty()) {
                ExclusionStrategy[] strategies = this.exclusionStrategies.toArray(new ExclusionStrategy[this.exclusionStrategies.size()]);
                builder.setExclusionStrategies(strategies);
            }
            if (this.longSerializationPolicy != null) {
                builder.setLongSerializationPolicy(this.longSerializationPolicy);
            }
            if (this.fieldNamingPolicy != null) {
                builder.setFieldNamingPolicy(this.fieldNamingPolicy);
            }
            if (this.fieldNamingStrategy != null) {
                builder.setFieldNamingStrategy(this.fieldNamingStrategy);
            }
            if (this.serializeNulls != null && this.serializeNulls.booleanValue()) {
                builder.serializeNulls();
            }
            if (this.prettyPrinting != null && this.prettyPrinting.booleanValue()) {
                builder.setPrettyPrinting();
            }
            if (this.dateFormatPattern != null) {
                builder.setDateFormat(this.dateFormatPattern);
            }
            this.gson = builder.create();
        }
    }

    protected void doStop() throws Exception {
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public List<ExclusionStrategy> getExclusionStrategies() {
        return this.exclusionStrategies;
    }

    public void setExclusionStrategies(List<ExclusionStrategy> exclusionStrategies) {
        this.exclusionStrategies = exclusionStrategies;
    }

    public LongSerializationPolicy getLongSerializationPolicy() {
        return this.longSerializationPolicy;
    }

    public void setLongSerializationPolicy(LongSerializationPolicy longSerializationPolicy) {
        this.longSerializationPolicy = longSerializationPolicy;
    }

    public FieldNamingPolicy getFieldNamingPolicy() {
        return this.fieldNamingPolicy;
    }

    public void setFieldNamingPolicy(FieldNamingPolicy fieldNamingPolicy) {
        this.fieldNamingPolicy = fieldNamingPolicy;
    }

    public FieldNamingStrategy getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public void setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
    }

    public Boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public void setSerializeNulls(Boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public Boolean getPrettyPrinting() {
        return this.prettyPrinting;
    }

    public void setPrettyPrinting(Boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public Gson getGson() {
        return this.gson;
    }
}

