/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.cw;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.cw.CwConfiguration;
import org.apache.camel.component.aws.cw.CwProducer;
import org.apache.camel.impl.DefaultEndpoint;

public class CwEndpoint
extends DefaultEndpoint {
    private CwConfiguration configuration;
    private AmazonCloudWatch cloudWatchClient;

    @Deprecated
    public CwEndpoint(String uri, CamelContext context, CwConfiguration configuration) {
        super(uri, context);
        this.configuration = configuration;
    }

    public CwEndpoint(String uri, Component component, CwConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new CwProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public void doStart() throws Exception {
        super.doStart();
    }

    public CwConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CwConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setCloudWatchClient(AmazonCloudWatch cloudWatchClient) {
        this.cloudWatchClient = cloudWatchClient;
    }

    public AmazonCloudWatch getCloudWatchClient() {
        if (this.cloudWatchClient == null) {
            this.cloudWatchClient = this.configuration.getAmazonCwClient() != null ? this.configuration.getAmazonCwClient() : this.createCloudWatchClient();
        }
        return this.cloudWatchClient;
    }

    AmazonCloudWatch createCloudWatchClient() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        AmazonCloudWatchClient client = new AmazonCloudWatchClient((AWSCredentials)credentials);
        if (this.configuration.getAmazonCwEndpoint() != null) {
            client.setEndpoint(this.configuration.getAmazonCwEndpoint());
        }
        return client;
    }
}

