/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import org.apache.camel.Converter;

@Converter
public final class HL7Converter {
    private static final HapiContext DEFAULT_CONTEXT = new DefaultHapiContext(ValidationContextFactory.noValidation());

    private HL7Converter() {
    }

    @Converter
    public static String toString(Message message) throws HL7Exception {
        return HL7Converter.encode(message, (Parser)new PipeParser());
    }

    @Converter
    public static byte[] toByteArray(Message message) throws HL7Exception {
        return message.encode().getBytes();
    }

    @Converter
    public static Message toMessage(String body) throws HL7Exception {
        return HL7Converter.parse(body, (Parser)new PipeParser());
    }

    @Converter
    public static Message toMessage(byte[] body) throws HL7Exception {
        return HL7Converter.parse(new String(body), (Parser)DEFAULT_CONTEXT.getGenericParser());
    }

    static Message parse(String body, Parser parser) throws HL7Exception {
        return parser.parse(body);
    }

    static String encode(Message message, Parser parser) throws HL7Exception {
        return parser.encode(message);
    }
}

