/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import org.apache.camel.component.hl7.HL7MLLPConfig;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HL7MLLPDecoder
extends CumulativeProtocolDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(HL7MLLPDecoder.class);
    private static final String DECODER_STATE = HL7MLLPDecoder.class.getName() + ".STATE";
    private static final String CHARSET_DECODER = HL7MLLPDecoder.class.getName() + ".charsetdecoder";
    private HL7MLLPConfig config;

    HL7MLLPDecoder(HL7MLLPConfig config) {
        this.config = config;
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) {
        DecoderState state = this.decoderState(session);
        in.position(state.current());
        while (in.hasRemaining()) {
            byte current = in.get();
            if (current == this.config.getStartByte()) {
                state.markStart(in.position() - 1);
            }
            if (state.previous() == this.config.getEndByte1() && current == this.config.getEndByte2()) {
                int position = in.position();
                int limit = in.limit();
                LOG.debug("Message ends at position {} with length {}", (Object)position, (Object)(position - state.start()));
                try {
                    in.position(state.start());
                    in.limit(position);
                    out.write(this.parseMessage(in.slice(), this.charsetDecoder(session)));
                }
                catch (CharacterCodingException cce) {
                    throw new IllegalArgumentException("Exception while finalizing the message", cce);
                }
                finally {
                    in.limit(limit);
                    in.position(position);
                    state.reset();
                }
                return true;
            }
            state.markPrevious(current);
        }
        LOG.debug("No complete message yet at position {} ", (Object)in.position());
        state.markCurrent(in.position());
        in.position(0);
        return false;
    }

    private Object parseMessage(IoBuffer slice, CharsetDecoder decoder) throws CharacterCodingException {
        slice.skip(1);
        String message = slice.getString(slice.limit() - 3, decoder);
        if (this.config.isConvertLFtoCR()) {
            message = message.replace('\n', '\r');
        }
        return message;
    }

    public void dispose(IoSession session) throws Exception {
        session.removeAttribute((Object)DECODER_STATE);
        session.removeAttribute((Object)CHARSET_DECODER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharsetDecoder charsetDecoder(IoSession session) {
        IoSession ioSession = session;
        synchronized (ioSession) {
            CharsetDecoder decoder = (CharsetDecoder)session.getAttribute((Object)CHARSET_DECODER);
            if (decoder == null) {
                decoder = this.config.getCharset().newDecoder();
                session.setAttribute((Object)CHARSET_DECODER, (Object)decoder);
            }
            return decoder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecoderState decoderState(IoSession session) {
        IoSession ioSession = session;
        synchronized (ioSession) {
            DecoderState decoderState = (DecoderState)session.getAttribute((Object)DECODER_STATE);
            if (decoderState == null) {
                decoderState = new DecoderState();
                session.setAttribute((Object)DECODER_STATE, (Object)decoderState);
            }
            return decoderState;
        }
    }

    private static class DecoderState {
        private int startPos;
        private int currentPos;
        private byte previousByte;
        private boolean started;

        private DecoderState() {
        }

        void reset() {
            this.startPos = 0;
            this.currentPos = 0;
            this.started = false;
            this.previousByte = 0;
        }

        void markStart(int position) {
            if (this.started) {
                LOG.warn("Ignoring message start at position {} before previous message has ended.", (Object)position);
            } else {
                this.startPos = position;
                LOG.debug("Message starts at position {}", (Object)this.startPos);
                this.started = true;
            }
        }

        void markCurrent(int position) {
            this.currentPos = position;
        }

        void markPrevious(byte previous) {
            this.previousByte = previous;
        }

        public int start() {
            return this.startPos;
        }

        public int current() {
            return this.currentPos;
        }

        public byte previous() {
            return this.previousByte;
        }
    }
}

