/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.LoggerFactory;

public class LoggingErrorHandlerBuilderTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testLoggingErrorHandler() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                LoggingErrorHandlerBuilder eh = this.loggingErrorHandler();
                eh.setLevel(LoggingLevel.ERROR);
                eh.setLog(LoggerFactory.getLogger((String)"foo"));
                TestCase.assertEquals((Object)LoggingLevel.ERROR, (Object)eh.getLevel());
                TestCase.assertNotNull((Object)eh.getLog());
                TestCase.assertFalse((boolean)eh.supportTransacted());
                this.errorHandler((ErrorHandlerBuilder)eh);
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            LoggingErrorHandlerBuilderTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLoggingErrorHandler2() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.loggingErrorHandler().level(LoggingLevel.WARN).log(LoggerFactory.getLogger((String)"foo")));
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            LoggingErrorHandlerBuilderTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLoggingErrorHandler3() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                LoggingErrorHandlerBuilder eh = this.loggingErrorHandler(LoggerFactory.getLogger((String)"foo"));
                eh.setLevel(LoggingLevel.ERROR);
                TestCase.assertEquals((Object)LoggingLevel.ERROR, (Object)eh.getLevel());
                TestCase.assertNotNull((Object)eh.getLog());
                TestCase.assertFalse((boolean)eh.supportTransacted());
                this.errorHandler((ErrorHandlerBuilder)eh);
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            LoggingErrorHandlerBuilderTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLoggingErrorHandler4() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                LoggingErrorHandlerBuilder eh = this.loggingErrorHandler(LoggerFactory.getLogger((String)"foo"), LoggingLevel.ERROR);
                TestCase.assertEquals((Object)LoggingLevel.ERROR, (Object)eh.getLevel());
                TestCase.assertNotNull((Object)eh.getLog());
                TestCase.assertFalse((boolean)eh.supportTransacted());
                this.errorHandler((ErrorHandlerBuilder)eh);
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            LoggingErrorHandlerBuilderTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLoggingErrorHandler5() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.loggingErrorHandler().level(LoggingLevel.ERROR).logName("foo"));
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            LoggingErrorHandlerBuilderTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLoggingErrorHandler6() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.loggingErrorHandler().level(LoggingLevel.WARN).logName("foo"));
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            LoggingErrorHandlerBuilderTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

