/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class ValueBuilderTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testAppend() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.body().append((Object)" World"))).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testPrepend() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "))).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testMatches() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((ValueBuilder)mock.message(0).body()).matches(new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                String body = (String)exchange.getIn().getBody(String.class);
                Boolean answer = body.contains("Camel");
                return type.cast(answer);
            }
        });
        this.template.sendBody("direct:start", (Object)"Camel rocks");
        mock.assertIsSatisfied();
        mock.reset();
        ((ValueBuilder)mock.message(0).body()).matches(new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                String body = (String)exchange.getIn().getBody(String.class);
                Boolean answer = body.contains("Camel");
                return type.cast(answer);
            }
        });
        this.template.sendBody("direct:start", (Object)"Hello World");
        mock.assertIsNotSatisfied();
    }
}

