/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.FileNotFoundException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.xml.InvalidXPathExpression;
import org.apache.camel.builder.xml.XPathBuilder;

public class XPathFeatureTest
extends ContextTestSupport {
    public static final String DOM_BUILER_FACTORY_FEATRUE = "org.apache.camel.xmlconverter.documentBuilderFactory.feature";
    public static final String XML_DATA = " <!DOCTYPE foo [  <!ELEMENT foo ANY > <!ENTITY xxe SYSTEM \"file:///bin/test.sh\" >]> <test> &xxe; </test>";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testXPathResult() throws Exception {
        String result = (String)XPathBuilder.xpath((String)"/").stringResult().evaluate(this.createExchange(XML_DATA));
        XPathFeatureTest.assertEquals((String)"Get a wrong result", (String)"  ", (String)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXPath() throws Exception {
        System.setProperty("org.apache.camel.xmlconverter.documentBuilderFactory.feature:http://xml.org/sax/features/external-general-entities", "true");
        try {
            XPathBuilder.xpath((String)"/").stringResult().evaluate(this.createExchange(XML_DATA));
            XPathFeatureTest.fail((String)"Expect an Exception here");
        }
        catch (Exception ex) {
            XPathFeatureTest.assertTrue((String)"Get a wrong exception cause.", (boolean)(ex instanceof InvalidXPathExpression));
            XPathFeatureTest.assertTrue((String)"Get a wrong exception cause.", (boolean)(ex.getCause() instanceof XPathExpressionException));
            XPathFeatureTest.assertTrue((String)"Get a wrong exception cause.", (boolean)(ex.getCause().getCause() instanceof FileNotFoundException));
        }
        finally {
            System.clearProperty("org.apache.camel.xmlconverter.documentBuilderFactory.feature:http://xml.org/sax/features/external-general-entities");
        }
    }

    protected Exchange createExchange(Object xml) {
        Exchange exchange = this.createExchangeWithBody((CamelContext)this.context, xml);
        return exchange;
    }
}

