/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BeanMethodHeartbeatTest;

public class BeanConsumerShutdownTest
extends ContextTestSupport {
    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("service", (Object)new BeanMethodHeartbeatTest.MyService("service1"));
        return context;
    }

    public void testHeartbeatsArrive() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMinimumMessageCount(1);
        resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("bean:service?method=status").to("seda:heartbeats");
                this.from("seda:heartbeats").delay(2000L).to("mock:result");
            }
        };
    }
}

