/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanEndpoint;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.impl.JndiRegistry;

public class BeanEndpointTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new FooBean());
        return jndi;
    }

    public void testBeanEndpointCtr() throws Exception {
        final BeanEndpoint endpoint = new BeanEndpoint();
        endpoint.setCamelContext((CamelContext)this.context);
        endpoint.setEndpointUriIfNotSpecified("bean:foo");
        endpoint.setBeanName("foo");
        BeanEndpointTest.assertEquals((String)"foo", (String)endpoint.getBeanName());
        BeanEndpointTest.assertEquals((boolean)false, (boolean)endpoint.isCache());
        BeanEndpointTest.assertNull((Object)endpoint.getBeanHolder());
        BeanEndpointTest.assertNull((Object)endpoint.getMethod());
        BeanEndpointTest.assertEquals((String)"bean:foo", (String)endpoint.getEndpointUri());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        BeanEndpointTest.assertEquals((String)"Hello World", (String)out);
    }

    public void testBeanEndpointCtrComponent() throws Exception {
        BeanComponent comp = (BeanComponent)this.context.getComponent("bean", BeanComponent.class);
        final BeanEndpoint endpoint = new BeanEndpoint("bean:foo", (Component)comp);
        endpoint.setCamelContext((CamelContext)this.context);
        endpoint.setBeanName("foo");
        BeanEndpointTest.assertEquals((String)"foo", (String)endpoint.getBeanName());
        BeanEndpointTest.assertEquals((boolean)false, (boolean)endpoint.isCache());
        BeanEndpointTest.assertNull((Object)endpoint.getBeanHolder());
        BeanEndpointTest.assertNull((Object)endpoint.getMethod());
        BeanEndpointTest.assertEquals((String)"bean:foo", (String)endpoint.getEndpointUri());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        BeanEndpointTest.assertEquals((String)"Hello World", (String)out);
    }

    public void testBeanEndpointCtrComponentBeanProcessor() throws Exception {
        BeanComponent comp = (BeanComponent)this.context.getComponent("bean", BeanComponent.class);
        RegistryBean holder = new RegistryBean((CamelContext)this.context, "foo");
        BeanProcessor bp = new BeanProcessor((BeanHolder)holder);
        final BeanEndpoint endpoint = new BeanEndpoint("bean:foo", (Component)comp, bp);
        endpoint.setBeanName("foo");
        BeanEndpointTest.assertEquals((String)"foo", (String)endpoint.getBeanName());
        BeanEndpointTest.assertEquals((boolean)false, (boolean)endpoint.isCache());
        BeanEndpointTest.assertNull((Object)endpoint.getBeanHolder());
        BeanEndpointTest.assertNull((Object)endpoint.getMethod());
        BeanEndpointTest.assertEquals((String)"bean:foo", (String)endpoint.getEndpointUri());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        BeanEndpointTest.assertEquals((String)"Hello World", (String)out);
    }

    public void testBeanEndpointCtrWithMethod() throws Exception {
        final BeanEndpoint endpoint = new BeanEndpoint();
        endpoint.setCamelContext((CamelContext)this.context);
        endpoint.setBeanName("foo");
        endpoint.setMethod("hello");
        BeanEndpointTest.assertEquals((String)"foo", (String)endpoint.getBeanName());
        BeanEndpointTest.assertEquals((boolean)false, (boolean)endpoint.isCache());
        BeanEndpointTest.assertNull((Object)endpoint.getBeanHolder());
        BeanEndpointTest.assertEquals((String)"hello", (String)endpoint.getMethod());
        BeanEndpointTest.assertEquals((String)"bean:foo?method=hello", (String)endpoint.getEndpointUri());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        BeanEndpointTest.assertEquals((String)"Hello World", (String)out);
    }

    public void testBeanEndpointCtrWithMethodAndCache() throws Exception {
        final BeanEndpoint endpoint = new BeanEndpoint();
        endpoint.setCamelContext((CamelContext)this.context);
        endpoint.setCache(true);
        endpoint.setMultiParameterArray(false);
        endpoint.setBeanName("foo");
        endpoint.setMethod("hello");
        BeanEndpointTest.assertEquals((String)"foo", (String)endpoint.getBeanName());
        BeanEndpointTest.assertEquals((boolean)true, (boolean)endpoint.isCache());
        BeanEndpointTest.assertNull((Object)endpoint.getBeanHolder());
        BeanEndpointTest.assertEquals((String)"hello", (String)endpoint.getMethod());
        BeanEndpointTest.assertEquals((String)"bean:foo?method=hello", (String)endpoint.getEndpointUri());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        BeanEndpointTest.assertEquals((String)"Hello World", (String)out);
        out = (String)this.template.requestBody("direct:start", (Object)"Moon", String.class);
        BeanEndpointTest.assertEquals((String)"Hello Moon", (String)out);
    }

    public void testBeanEndpointCtrWithBeanHolder() throws Exception {
        final BeanEndpoint endpoint = new BeanEndpoint();
        endpoint.setCamelContext((CamelContext)this.context);
        RegistryBean holder = new RegistryBean((CamelContext)this.context, "foo");
        endpoint.setBeanHolder((BeanHolder)holder);
        BeanEndpointTest.assertEquals((boolean)false, (boolean)endpoint.isCache());
        BeanEndpointTest.assertEquals((Object)holder, (Object)endpoint.getBeanHolder());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        String out = (String)this.template.requestBody("direct:start", (Object)"World", String.class);
        BeanEndpointTest.assertEquals((String)"Hello World", (String)out);
    }

    public class FooBean {
        public String hello(String hello) {
            return "Hello " + hello;
        }
    }
}

