/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;

public class BeanExchangeAsReturnTypeNotAllowedTest
extends ContextTestSupport {
    public void testExchangeAsReturnTypeNotAllowed() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:in", (Object)"Hello World");
            BeanExchangeAsReturnTypeNotAllowedTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (RuntimeCamelException e) {
            BeanExchangeAsReturnTypeNotAllowedTest.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
        result.assertIsSatisfied();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:in").to("bean:myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public Exchange doSomething(Exchange exchange) {
            return exchange;
        }
    }
}

