/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class BeanInvokeTest
extends ContextTestSupport {
    public void testA() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:a");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{""});
        this.template.sendBody("direct:a", (Object)"");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).isNull();
        this.template.sendBody("direct:a", null);
        this.assertMockEndpointsSatisfied();
    }

    public void testB() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:b");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:b", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).isNull();
        this.template.sendBody("direct:b", (Object)"");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).isNull();
        this.template.sendBody("direct:b", null);
        this.assertMockEndpointsSatisfied();
    }

    public void testC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:c");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:c", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{""});
        this.template.sendBody("direct:c", (Object)"");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).body()).isNull();
        this.template.sendBody("direct:c", null);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").bean(BeanInvokeTest.class, "doSomething")).to("mock:a");
                ((RouteDefinition)this.from("direct:b").bean(BeanInvokeTest.class, "changeSomething")).to("mock:b");
                ((RouteDefinition)this.from("direct:c").bean(BeanInvokeTest.class, "doNothing")).to("mock:c");
            }
        };
    }

    public String doSomething(String s) {
        return s;
    }

    public String changeSomething(String s) {
        if ("Hello World".equals(s)) {
            return "Bye World";
        }
        return null;
    }

    public void doNothing(String s) {
    }
}

