/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Handler;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.RouteDefinition;

public class BeanMethodNameHeaderIssueTest
extends ContextTestSupport {
    public void testBeanMethodNameHeaderIssue() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"foo"});
        ((ValueBuilder)this.getMockEndpoint("mock:a").message(0).header("CamelBeanMethodName")).isNull();
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"bar"});
        ((ValueBuilder)this.getMockEndpoint("mock:b").message(0).header("CamelBeanMethodName")).isNull();
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Bye bar"});
        ((ValueBuilder)this.getMockEndpoint("mock:c").message(0).header("CamelBeanMethodName")).isNull();
        this.getMockEndpoint("mock:d").expectedBodiesReceived(new Object[]{"Bye bar Bye bar"});
        ((ValueBuilder)this.getMockEndpoint("mock:d").message(0).header("CamelBeanMethodName")).isNull();
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelBeanMethodName", (Object)"foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").bean(BeanMethodNameHeaderIssueTest.class)).to("mock:a")).bean(BeanMethodNameHeaderIssueTest.class, "bar")).to("mock:b")).bean(BeanMethodNameHeaderIssueTest.class)).to("mock:c")).setHeader("CamelBeanMethodName", (Expression)this.constant("echo"))).bean(BeanMethodNameHeaderIssueTest.class)).to("mock:d");
            }
        };
    }

    public String foo() {
        return "foo";
    }

    public String bar() {
        return "bar";
    }

    public String echo(String body) {
        return body + " " + body;
    }

    @Handler
    public String doSomething(String body) {
        return "Bye " + body;
    }
}

