/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.component.bean.MyDummyBean;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.impl.JndiRegistry;

public class BeanRegistryBeanTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        jndi.bind("static", MyFooBean.class);
        return jndi;
    }

    public void testNoBean() {
        RegistryBean rb = new RegistryBean((CamelContext)this.context, "bar");
        try {
            rb.getBean();
            BeanRegistryBeanTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchBeanException e) {
            BeanRegistryBeanTest.assertEquals((String)"bar", (String)e.getName());
        }
    }

    public void testBean() {
        RegistryBean rb = new RegistryBean((CamelContext)this.context, "foo");
        Object bean = rb.getBean();
        BeanRegistryBeanTest.assertIsInstanceOf(MyFooBean.class, bean);
        BeanRegistryBeanTest.assertNotNull((Object)rb.getContext());
        BeanRegistryBeanTest.assertEquals((String)"foo", (String)rb.getName());
        BeanRegistryBeanTest.assertNotNull((Object)rb.getParameterMappingStrategy());
        BeanRegistryBeanTest.assertNotNull((Object)rb.getRegistry());
    }

    public void testParameterMappingStrategy() {
        RegistryBean rb = new RegistryBean((CamelContext)this.context, "foo");
        ParameterMappingStrategy myStrategy = new ParameterMappingStrategy(){

            public Expression getDefaultParameterTypeExpression(Class<?> parameterType) {
                return null;
            }
        };
        rb.setParameterMappingStrategy(myStrategy);
        Object bean = rb.getBean();
        BeanRegistryBeanTest.assertIsInstanceOf(MyFooBean.class, bean);
        BeanRegistryBeanTest.assertNotNull((Object)rb.getContext());
        BeanRegistryBeanTest.assertEquals((String)"foo", (String)rb.getName());
        BeanRegistryBeanTest.assertEquals((Object)myStrategy, (Object)rb.getParameterMappingStrategy());
        BeanRegistryBeanTest.assertNotNull((Object)rb.getRegistry());
    }

    public void testLookupClass() throws Exception {
        RegistryBean rb = new RegistryBean((CamelContext)this.context, "static");
        Object bean = rb.getBean();
        MyFooBean foo = BeanRegistryBeanTest.assertIsInstanceOf(MyFooBean.class, bean);
        BeanRegistryBeanTest.assertEquals((String)"foofoo", (String)foo.echo("foo"));
    }

    public void testLookupFQNClass() throws Exception {
        RegistryBean rb = new RegistryBean((CamelContext)this.context, "org.apache.camel.component.bean.MyDummyBean");
        Object bean = rb.getBean();
        MyDummyBean dummy = BeanRegistryBeanTest.assertIsInstanceOf(MyDummyBean.class, bean);
        BeanRegistryBeanTest.assertEquals((String)"Hello World", (String)dummy.hello("World"));
    }

    public static class MyFooBean {
        public String echo(String s) {
            return s + s;
        }
    }
}

