/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;

public class BeanWithAnnotationAndExchangeTest
extends ContextTestSupport {
    public void testBeanWithAnnotationAndExchangeTest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"StartMyBean"});
        mock.expectedHeaderReceived("user", (Object)"admin");
        this.template.requestBody("direct:in", (Object)"Start");
        mock.assertIsSatisfied();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)new MyBean());
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:in").setHeader("user", (Expression)this.constant("admin"))).to("bean:myBean")).to("mock:result");
            }
        };
    }

    public static class MyBean {
        public void doSomething(@Header(value="user") String user, @Body String body, Exchange exchange) {
            TestCase.assertEquals((String)"admin", (String)user);
            exchange.getIn().setBody((Object)(body + "MyBean"));
        }
    }
}

