/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.Attachments;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;

public class BeanWithAttachmentAnnotationTest
extends ContextTestSupport {
    public void testBeanWithAnnotationAndExchangeTest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"attachment"});
        this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setPattern(ExchangePattern.InOut);
                Message m = exchange.getIn();
                m.addAttachment("attachment", new DataHandler((DataSource)new FileDataSource("src/test/org/apache/camel/component/bean/BeanWithAttachmentAnnotationTest.java")));
            }
        });
        mock.assertIsSatisfied();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("processor", (Object)new AttachmentProcessor());
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:in").to("bean:processor")).to("mock:result");
            }
        };
    }

    public static class AttachmentProcessor {
        public String doSomething(@Attachments Map<String, DataHandler> attachments) {
            TestCase.assertNotNull(attachments);
            TestCase.assertEquals((String)"The attache size is wrong", (int)1, (int)attachments.size());
            String key = attachments.keySet().iterator().next();
            TestCase.assertNotNull((Object)key);
            TestCase.assertNotNull((Object)attachments.get(key));
            DataHandler handler = attachments.get(key);
            TestCase.assertNotNull((Object)handler);
            TestCase.assertTrue((String)"The data source should be a instance of FileDataSource", (boolean)(handler.getDataSource() instanceof FileDataSource));
            return key;
        }
    }
}

